package org.lixm.optional.v16.framework.model;

import org.lixm.core.common.XMLType;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.ElementModel;

/**
 * <p>vff܂B</p>
 * 
 * @author tasogare
 * @since 1.5
 *
 */
public class ElementModelImpl extends AbstractModel implements ElementModel{

	protected String name;
	protected String  pref;
	protected String  id;

	private ElementModelImpl(){}

    /**
     * <p>[JvfAOԃvtBbNXAOURIw肵ăf܂B</p>
     * 
     * <p>OԃvtBbNXƖOURI݂Ȃꍇ<code>null</code>łB</p>
     * 
     * @param name [J̗vf
     * @param pref OԃvtBbNXB݂Ȃꍇ<code>null</code>
     * @param id OURIB݂Ȃꍇ<code>null</code>
     */
    public ElementModelImpl(String name, String pref, String id){
        super(XMLType.ELEMENT);

        this.name = name;
        this.pref = pref;
        this.id = id;
    }

    /**
     * <p>ˑ̕@ŗvf擾܂B<br>
     * ɃfobOGh[U[bZ[Wɗp郆[eBeBłB</p>
     * 
     * vf̃[J⊮SC擾ꍇ{@link #toLocalName()}
     * {@link #toQname()}𗘗pĉB
     * 
     * @see #toLocalName()
     * @see #toQname()
     * 
     * @return ˑȗvf
     */
    public String getName(){
	    return name;
	}

    /**
     * <p>OԃvtBbNX擾܂B݂Ȃꍇ<code>null</code>ƂȂ܂B</p>
     * @return OԃvtBbNXB݂Ȃꍇ<code>null</code>
     */
    public String  getPefix(){
        return pref;
    }

    /**
     * <p>OURI擾܂B݂Ȃꍇ<code>nullƂȂ܂B</code></p>
     * @return OURIB݂Ȃꍇ<code>null</code>
     */
    public String  getNamespace(){
        return id;
    }

    /**
     * <p>vf̃[J擾܂B</p>
     * 
     * @return vf̃[J
     */
    public String  toLocalName(){
	    return name;
	}

    /**
     * <p>vf̊SC擾܂BSC݂ȂꍇK<code>null</code>
     * ɂȂ܂B</p>
     * 
     * @return vf̊SCBSC݂Ȃꍇ<code>null</code>B
     */
    public String  toQname(){
	    String QName = null;
	    if(getPefix() != null){
	        QName = getPefix() + ":" + toLocalName( );
	    }
	    return QName;
	}

    /**
     * {@inheritDoc}
     */
    @Override public String toString(){
	    return toLocalName();
	}

    /**
     * <p>f̓ꐫ_Iɒׂ̌ʂԂ܂B</p>
     * @return ̃fȂ<code>true</code>AႤȂ<code>false</code>B
     */
    @Override public boolean equals(Object o){
		if(!super.equals(o)) return false;
		return (
            this.toLocalName( ).equals(((ElementModel)o).toLocalName( )) &&
            this.toQname( ).equals(((ElementModel)o).toQname( )) &&
            this.getNamespace( ).equals(((ElementModel)o).getNamespace( )) &&
            this.getPefix( ).equals(((ElementModel)o).getPefix( ))
        );
	}

	/**
	 * <p>f̃N[Ԃ܂B</p>
	 * @return f̃N[
	 * @since 1.6
	 */
	@Override public Object clone(){
		return (Object)new ElementModelImpl(this.name, this.pref, this.id);
		
	}
	
}
