package org.pigeonblood.impl.core.modelizer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.XMLModel;
import org.lixm.optional.v15.atattch.LIXMConfigurable;
import org.lixm.optional.v15.atattch.LIXMConfigurationException;
import org.lixm.optional.v15.atattch.LIXMConfigurationSupport;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

/**
 * Pigeonblood񋟂郂fCU̎łB
 * TODO of[^
 * 
 * @author tasogare
 * @since 0.1
 * 
 */
public class SimpleXMLModelizer implements XMLModelizer, LIXMConfigurable {

	private SAXParserFactory saxf;
	private SAXParser saxp;

	private SimpleModelizerHandler handler;

	private LIXMConfigurationSupport configuration;
	private XMLDocumentList<XMLModel> list;

	private SimpleXMLModelizer() throws LIXMPhaseException {
		saxf = SAXParserFactory.newInstance();
	}

	/**
	 * fCȔƓɃXg֘AtRXgN^łB
	 * 
	 * @param list
	 *        ֘At郊Xg
	 * @throws LIXMPhaseException
	 *         vvZXtF[YƂėO\܂
	 */
	public SimpleXMLModelizer(XMLDocumentList<XMLModel> list)
			throws LIXMPhaseException {
		this();
		setList(list);
	}

	/**
	 * fCȔƓɃXg֘AtARtBMAݒ肵܂B
	 * 
	 * @param list
	 *        ֘At郊Xg
	 * @param configure
	 *        ݒ肷RtBMA
	 * @throws LIXMPhaseException
	 *         vvZXtF[YƂėO\܂
	 */
	public SimpleXMLModelizer(XMLDocumentList<XMLModel> list,
			LIXMConfigurationSupport configure) throws LIXMPhaseException {
		this(list);
		this.configuration = configure;
	}

	private void factoryInit() throws LIXMPhaseException {

		saxf.setNamespaceAware(true);

		boolean validation = false;
		try {
			validation = getConfigure().getFeature(
					LIXMConfigurationSupport.VALIDATION);
		} catch (LIXMConfigurationException e) {
			// Ȃ
		} catch (NullPointerException e) {
			// Ȃ
		}

		saxf.setValidating(validation);

		if (validation) {

			Schema schema = null;
			try {
				schema = (Schema) getConfigure().getProperty(
						LIXMConfigurationSupport.SCHEMA);
			} catch (LIXMConfigurationException e) {
				// Ȃ
			} catch (NullPointerException e) {
				// Ȃ
			}

			if (validation && schema != null) {
				saxf.setSchema(schema);
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public LIXMConfigurationSupport getConfigure() {
		return configuration;
	}

	/**
	 * fCYɗpnh擾܂B
	 * 
	 * @return fCYɗpnh
	 */
	public SimpleModelizerHandler getHandler() {
		return handler;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public XMLDocumentList<? extends XMLModel> getList() {
		return list;
	}

	private XMLReader getXMLReader() throws LIXMPhaseException {

		XMLReader r = null;

		try {
			r = saxp.getXMLReader();
		} catch (SAXException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
		}

		return r;
	}

	/**
	 * {@linkplain InputStream}\[XƂāAfCYtF[YJn܂B
	 * 
	 * @param is
	 *        \[XƂXg[
	 * @throws LIXMPhaseException
	 *         fCYɉ炩̗O ꍇ܂B ̗ObvĂ\܂B
	 */
	public void modelize(InputStream is) throws LIXMPhaseException {
		factoryInit();
		parserInit();
		startParse(getXMLReader(), is);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void modelize(String name) throws LIXMPhaseException {
		modelize(getClass().getClassLoader().getResourceAsStream(name));
	}

	/**
	 * {@linkplain URL}\[XƂāAfCYtF[YJn܂B
	 * 
	 * @param url
	 *        \[XƂURL
	 * @throws LIXMPhaseException
	 *         fCYɉ炩̗O ꍇ܂B ̗ObvĂ\܂B
	 */
	public void modelize(URL url) throws LIXMPhaseException {
		InputStream is = null;
		try {
			is = url.openStream();
		} catch (IOException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
		}
		modelize(is);
	}

	@SuppressWarnings("unchecked")
	private void parserInit() throws LIXMPhaseException {
		try {
			saxp = saxf.newSAXParser();
		} catch (ParserConfigurationException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
		} catch (SAXException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
		}

		handler = new SimpleModelizerHandler(getConfigure(),
				(XMLDocumentList<XMLModel>) getList());

		try {
			saxp.getXMLReader().setProperty(
					"http://xml.org/sax/properties/lexical-handler", handler);
		} catch (SAXNotRecognizedException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
		} catch (SAXNotSupportedException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
		} catch (SAXException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
		}

		try {
			saxp.getXMLReader().setContentHandler(handler);
		} catch (SAXException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setConfigure(LIXMConfigurationSupport configure) {
		this.configuration = configure;
	}

	/**
	 * <p> fCUŎgnhύXł܂B </p> <p>
	 * ɂ胂fCY̏ڍׂJX^}CYꂽ̂ɒu邱Ƃł܂B </p> <p> ̃\bh
	 * {@link #modelize(String)}A{@link #modelize(InputStream)}A
	 * {@link #modelize(URL)} ̑OɎsKv܂B </p>
	 * 
	 * @param handler
	 *        JX^}CYꂽfCYpnh
	 */
	public void setHandler(SimpleModelizerHandler handler) {
		this.handler = handler;
	}

	/**
	 * Cӂ̃Xg̃fCUɊ֘At܂B
	 * 
	 * @param list
	 *        ֘At郊Xg
	 */
	public void setList(XMLDocumentList<XMLModel> list) {
		this.list = list;
	}

	private void startParse(XMLReader r, InputStream is)
			throws LIXMPhaseException {
		try {
			InputStream istream = is;
			r.parse(new InputSource(istream));
		} catch (IOException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
		} catch (SAXException e) {
			throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
		}
	}
}
