package org.pigeonblood.test;

import java.awt.ScrollPane;
import java.io.IOException;
import java.io.OutputStream;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;

public class OutputComponent {

	JFrame outFrame;
	JTextArea outArea;
	JTextAreaOutputStreem outStreem;

	JFrame errFrame;
	JTextArea errArea;
	JTextAreaOutputStreem errStreem;

	public OutputComponent() {
		outArea = new JTextArea(20, 50);
		JScrollPane outScroller = new JScrollPane(outArea,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		outFrame = new JFrame("Wo");
		outFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		outFrame.getContentPane().add(outScroller);
		outFrame.pack();

		outStreem = new JTextAreaOutputStreem(outArea);

		errArea = new JTextArea(20, 50);
		JScrollPane errScroller = new JScrollPane(errArea,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		errFrame = new JFrame("WG[");
		errFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		errFrame.getContentPane().add(errScroller);
		errFrame.pack();

		errStreem = new JTextAreaOutputStreem(errArea);
	}

	public JFrame getOutputFrame() {
		return outFrame;
	}

	public JFrame getErrFrame() {
		return errFrame;
	}

	public OutputStream getOutStreem() {
		return outStreem;
	}

	public OutputStream getErrStreem() {
		return errStreem;
	}

	class JTextAreaOutputStreem extends OutputStream {

		JTextArea text;

		public JTextAreaOutputStreem(JTextArea text) {
			this.text = text;
		}

		@Override
		public void write(int i) throws IOException {
			char[] chars = new char[1];
			chars[0] = (char) i;
			text.append(new String(chars));
		}

		public void write(char[] buff, int off, int len) throws IOException {
			text.append(new String(buff, off, len));
		}
	}
}
