%define name lkstlogtools
%define version 1.1.0
%define release 1

%define prefix /usr

Name: %{name}
Summary: Linux Kernel State Tracer (LKST) Log Tools
Version: %{version}
Release: %{release}
Packager: HITACHI,LTD.
Group: Applications/System
Source: %{name}-%{version}.tar.gz
License: GPL
Vendor: HITACHI,LTD.
URL: http://sourceforge.net/projects/lkst/
BuildRoot: %{_tmppath}/%{name}-root/
BuildPreReq: autoconf

%description
The lkstlogtools package contains performance analysis tools for
Linux Kernel State Tracer (LKST). 

Authors:
--------
   M.HIRAMATSU <hiramatu@sdl.hitachi.co.jp>
   H.KAWAI <h-kawai@sdl.hitachi.co.jp>

%package drivers
Summary: Event handlers and scripts for LKST Log Tools
Version: %{version}
Release: %{release}
Packager: HITACHI,LTD.
Group: Applications/System
License: GPL
Vendor: HITACHI,LTD.
URL: http://sourceforge.net/projects/lkst/
BuildRoot: %{_tmppath}/%{name}-root/
BuildPreReq: autoconf

%description drivers
The lkstlogtools-drivers package contains performance analysis 
handlers and scripts for Linux Kernel State Tracer (LKST). 
This package should be installed into only the target host in 
which you'd like to evaluate performance.

Authors:
--------
   M.HIRAMATSU <hiramatu@sdl.hitachi.co.jp>
   H.KAWAI <h-kawai@sdl.hitachi.co.jp>


%prep
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
%setup
%build
autoconf
./configure --prefix=%{prefix} \
	    --with-ksrc=/lib/modules/2.6.9-lkst23/source \
	    --with-kbin= \
	    --mandir=%{_mandir}
make

%install
mkdir -p $RPM_BUILD_ROOT%{prefix}/sbin
mkdir -p $RPM_BUILD_ROOT%{prefix}/bin
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
mkdir -p $RPM_BUILD_ROOT/lib/modules/2.6.9-lkst23/kernel/drivers/lkst
make prefix=$RPM_BUILD_ROOT%{prefix} \
     mandir=$RPM_BUILD_ROOT%{_mandir} \
     MANDIR=$RPM_BUILD_ROOT%{_mandir} \
     KMODDIR=$RPM_BUILD_ROOT/lib/modules/2.6.9-lkst23/kernel/drivers/lkst \
     BINDIR=$RPM_BUILD_ROOT/%{prefix}/bin/ \
     SBINDIR=$RPM_BUILD_ROOT/%{prefix}/sbin/ \
     install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/depmod 2.6.9-lkst23

%files
%defattr(-, root, root)
%{prefix}/bin/*
%{_mandir}/man8/*

%files drivers
%defattr(-, root, root)
%{prefix}/sbin/*
/lib/modules/2.6.9-lkst23/kernel/drivers/lkst/*

%changelog
* Mon May 23 2005 Masami HIRAMATSU <hiramatu@sdl.hitachi.co.jp>
- divide into the main package and a "drivers" package.

* Fri May 13 2005 Masami HIRAMATSU <hiramatu@sdl.hitachi.co.jp>
- first release.(for version 1.1.0)
