/*
 block device processing time analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>

 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_bdevtime(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_bdevtime(struct lkst_log_record *rec);
static char * get_alias_bdevtime(slot_hkey key);
static ga_type_t get_type_bdevtime(struct lkst_log_record *);

extern struct gate_analyzer bdevtime_analyzer;

static int diff_key=0;

#if 0
static char * difftitle = " diffsct difsector";

static int extra_opt_handler_diff(int c, char*v) {
	diff_key = 1;
	bdevtime_analyzer.title = difftitle;
	return 0;
}

static struct command_option diff_option = {
	.opt = "D",
	.format = "-D",
	.description = "show sector difference instead of req-queue",
	.handler = extra_opt_handler_diff,
};
#endif

static int init_bdevtime(void);

struct gate_analyzer bdevtime_analyzer = {
	.name = "bdevtime",
	.description = "blockdevice processing time analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "req-queue", ADDR_LEN+1, "%*s" },
		[COL_METRIC] = { "blockdevtime" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_bdevtime,
	.session_key = session_key_bdevtime,
	.get_alias = get_alias_bdevtime,

	.get_type = get_type_bdevtime,

	.init = init_bdevtime,
	.nr_options = 0,
	.options = { NULL },//{&diff_option},
};

static generic_slots_t *gsl_req=NULL;// bio keyed req
static generic_slots_t *gsl_bio=NULL;// req keyed bio

static unsigned long long prev_sector = 0;
static unsigned long prev_req = 0;

static int init_bdevtime(void)
{
	gsl_req = new_generic_slots(5,sizeof(unsigned long));
	gsl_bio = new_generic_slots(5,sizeof(unsigned long));
	if (gsl_req==NULL || gsl_bio==NULL )return -ENOMEM;
	return 0;
}

static void map_each(unsigned long bio, unsigned long req) 
{
	slot_t *s;
	//register bio (req->bio 1:N)
	s = get_free_slot(gsl_bio, req);
	*(unsigned long *)slot_data(s) = bio;
	//register req (bio->req 1:1)
	s = find_slot(gsl_req, bio);
	if (!s) {
		s = get_free_slot(gsl_req, bio);
	}
	*(unsigned long *)slot_data(s) = req;
}

static void release_req_all(unsigned long req)
{
	slot_t *s;
	while ((s = find_slot(gsl_bio, req))!=NULL) {
		unsigned long bio = *(unsigned long *)slot_data(s);
		release_slot(gsl_req, bio);//release synonyms
		release_slot(gsl_bio, req);
	}
}

static unsigned long bio2req(unsigned long bio)
{
	slot_t *s;
	s = find_slot(gsl_req, bio);
	if (s) {
		return *(unsigned long *)slot_data(s);
	}

	return 0;
}

static slot_hkey info_key_bdevtime(struct lkst_log_record *rec_start,
				   struct lkst_log_record *rec_end)
{
	return (diff_key)? ARG3UL(rec_start): ARG1UL(rec_start);
}

static slot_hkey session_key_bdevtime(struct lkst_log_record *rec)
{
	slot_hkey ret;
	switch (rec->posix.log_event_type) {
	case LKST_ETYPE_BLK_PUT_REQ:
		return ARG4UL(rec); //request
	case LKST_ETYPE_BIO_END_IO:
		ret = bio2req(ARG1UL(rec));
		release_req_all(ret);
		return ret;
	default:
		return ARG2UL(rec); //request
	}
}

static char buf[256];

static char * get_alias_bdevtime(slot_hkey key)
{
	sprintf(buf, "%0*lx", ADDR_LEN, key);
	return buf;
}

static ga_type_t get_type_bdevtime(struct lkst_log_record *rec)
{
	unsigned long req = ARG2UL(rec);
	unsigned long long tmp;
	//TODO:error processing
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_BIO_MAKE_REQ2:
		map_each( ARG1UL(rec), ARG2UL(rec) );
		break;
	case LKST_ETYPE_ELV_NEXT_REQ:
		if (req == prev_req) break;
		prev_req = req;
		tmp = rec->log_arg3 + rec->log_arg4; // next end sct
		if (prev_sector == 0)
			rec->log_arg3 = 0;
		else 
			rec->log_arg3 -= prev_sector; //diff of sct
		prev_sector = tmp;
		return GAT_START;
	case LKST_ETYPE_BIO_END_IO:
		if (bio2req(ARG1UL(rec))==0)break;
		return GAT_END;
	case LKST_ETYPE_BLK_PUT_REQ:
		release_req_all(ARG4UL(rec));
		return GAT_REMOVE;
	default:
		;
	}
	return GAT_IGNORE;
}

