/*
 elv processing time analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>

 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_biomake(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_biomake(struct lkst_log_record *rec);
static char * get_alias_biomake(slot_hkey key);
static ga_type_t get_type_biomake(struct lkst_log_record *);

struct gate_analyzer biomake_analyzer = {
	.name = "biomake",
	.description = "bio insert to request time analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "req-queue", ADDR_LEN + 1, "%*s" },
		[COL_METRIC] = { "insert-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_1TO1_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_biomake,
	.session_key = session_key_biomake,
	.get_alias = get_alias_biomake,

	.get_type = get_type_biomake,

	.init = init_none,
};

static slot_hkey info_key_biomake(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end)
{
	return ARG3UL(rec_end);
}

static slot_hkey session_key_biomake(struct lkst_log_record *rec)
{
	return ARG1UL(rec);
}

static char buf[256];

static char * get_alias_biomake(slot_hkey key)
{
	sprintf(buf, "%0*lx", ADDR_LEN, key);
	return buf;
}

static ga_type_t get_type_biomake(struct lkst_log_record *rec)
{
	//TODO:error processing
	switch(rec->posix.log_event_type){
	case LKST_ETYPE_BIO_MAKE_REQ:
		return GAT_START;
	case LKST_ETYPE_BIO_MAKE_REQ2:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}

