/*
 LKST block request-queue analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <eventdesc.h>

static slot_hkey info_key_blkqueue(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_blkqueue(slot_hkey key);
static ga_type_t get_type_blkqueue(struct lkst_log_record *rec);
static double get_metric_blkqueue_len(struct lkst_log_record *rec_start,
				     struct lkst_log_record *rec_end);

struct gate_analyzer blkqueue_analyzer = {
	.name = "blkqueue",
	.description = "Block-IO request queue analyzer",
	.cols = {
		[COL_KEY] = { "rq-addr", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "requestqueue", ADDR_LEN + 4, "%*s" },
		[COL_METRIC] = { "req-queue-len" },
	},

	GA_INIT_EVENT_ANALYZER
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_DEF_LONG
	GA_INIT_RET_EVENT_PID
	GA_INIT_RET_EVENT_TIME

	.info_key = info_key_blkqueue,
	.get_alias = get_alias_blkqueue,

	.get_type = get_type_blkqueue,
	.get_metric = get_metric_blkqueue_len,

	.init = init_none,
};

static slot_hkey info_key_blkqueue(struct lkst_log_record *rec_start,
				   struct lkst_log_record *rec_end)
{
	return (rec_start->log_arg1 & (~1UL) ) | ARG2UL(rec_start);
}

static char buf[256];

static char * get_alias_blkqueue(slot_hkey key)
{
	sprintf(buf,"0x%0*lx%s", ADDR_LEN, key & (~1UL), (key&1)?"WR":"RD");
	return buf;
}

static ga_type_t get_type_blkqueue(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_BLK_GET_REQ:
	case LKST_ETYPE_BLK_PUT_REQ:
		return GAT_EVENT;
	default:
		return GAT_IGNORE;
	}
}

static double get_metric_blkqueue_len(struct lkst_log_record *rec_start,
				     struct lkst_log_record *rec_end)
{
	return (double)ARG3UL(rec_start);
}
