/*
 elv processing time/blkqueue-length analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_elvqueue(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_elvqueue(struct lkst_log_record *rec);
static char * get_alias_elvqueue(slot_hkey key);
static ga_type_t get_type_elvqueue(struct lkst_log_record *);

struct gate_analyzer elvqueue_analyzer = {
	.name = "elvqueue",
	.description = "ELV proc-time per queue-len analyzer",
	.cols = {
		[COL_KEY] = { "length", 7, "%*d" },
		[COL_ALIAS] = { "length-flag", 12, "%*s" },
		[COL_METRIC] = { "iosched-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_elvqueue,
	.session_key = session_key_elvqueue,
	.get_alias = get_alias_elvqueue,

	.get_type = get_type_elvqueue,

	.init = init_none,
};

static unsigned bqlen=0;

static slot_hkey info_key_elvqueue(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end)
{
	return ARG3UL(rec_start);
}

static slot_hkey session_key_elvqueue(struct lkst_log_record *rec)
{
	rec->log_arg3 = bqlen;
	return ARG2UL(rec);
}

static char buf[256];

static char * get_alias_elvqueue(slot_hkey key)
{
	sprintf(buf,"%05d-%s",
		(int)(key & 0xffff), (key >> 16)? "WR": "RD");
	return buf;
}

static ga_type_t get_type_elvqueue(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type){
	case LKST_ETYPE_BIO_MAKE_REQ2:
		return GAT_START;
	case LKST_ETYPE_ELV_NEXT_REQ:
		return GAT_END;
	case LKST_ETYPE_BLK_GET_REQ:
	case LKST_ETYPE_BLK_PUT_REQ:
		bqlen=(unsigned)((rec->log_arg3 & 0xffff) |
				 ((rec->log_arg2 & 0xffff)<<16));
	default:
		return GAT_IGNORE;
	}
}

