/*
 LKST events counting analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <eventdesc.h>

static slot_hkey info_key_event(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_event(slot_hkey key);
static ga_type_t get_type_event(struct lkst_log_record *rec);
static int init_event(void);
static double get_metric_event(struct lkst_log_record *start,
			      struct lkst_log_record *end);

struct gate_analyzer event_analyzer = {
	.name = "event",
	.description = "LKST events counting analyzer",
	.cols = {
		[COL_KEY] = { "etype", 5, "%*d" },
		[COL_ALIAS] = { "event_mnemonic", 22, "%*s" },
		[COL_METRIC] = { "n/a" },
	},

	GA_INIT_EVENT_ANALYZER
	GA_INIT_DEF_TIME
	GA_INIT_RET_EVENT_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_event,
	.get_alias = get_alias_event,

	.get_type = get_type_event,
	.get_metric = get_metric_event,

	.init = init_event,
	.nr_options = 1,
	.options[0] = &edesc_option,
};

#define NR_events LKST_ETYPE_MAX

static int init_event(void)
{
	return init_eventdesc();
}

static slot_hkey info_key_event(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return rec->posix.log_event_type;
}

static char * get_alias_event(slot_hkey key)
{
	if(key>=NR_events)
		return "(unknown)";
	else
		return lkst_etype_desc[key].mnemonic;
}

static ga_type_t get_type_event(struct lkst_log_record *rec)
{
	return  GAT_EVENT;
}

static double get_metric_event(struct lkst_log_record *start,
			      struct lkst_log_record *end)
{
	return 0;
}
