/*
 exception time distribution analyer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <ksymbols.h>

static slot_hkey info_key_exception(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_exception(struct lkst_log_record *rec);
static char * get_alias_exception(slot_hkey key);
static ga_type_t get_type_exception(struct lkst_log_record *rec);

struct gate_analyzer exception_analyzer = {
	.name = "exception",
	.description = "Exception processing analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "exception_handler", 30, "%*s" },
		[COL_METRIC] = { "processing-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_exception,
	.session_key = session_key_exception,
	.get_alias = get_alias_exception,
	.get_type = get_type_exception,

	.init = init_ksymbols,
	.nr_options = 1,
	.options = {&ksym_option},
};

static slot_hkey info_key_exception(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return (slot_hkey)(rec_start->log_arg1);
}
static slot_hkey session_key_exception(struct lkst_log_record *rec)
{
	return (slot_hkey)(rec->posix.log_pid);
}

static char * get_alias_exception(slot_hkey key)
{
	char *ret=get_symbol(key);
	if (ret == NULL)
		return "(unknown)";
	else
		return ret;
}

static ga_type_t get_type_exception(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_EXCEPTION_ENTRY:
		return GAT_START;
	case LKST_ETYPE_EXCEPTION_EXIT:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
