/*
 LKST log formatter

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <lkstla.h>

static int pre_analyze_log(struct gate_analyzer *ga);
static void callback_log(struct gate_analyzer *ga, slot_hkey key,
			 struct timespec *ets, double metric,int pid);
static void post_analyze_log(struct gate_analyzer *ga);
static int opt_handler_log(int c, char *opt);

struct analysis_formatter log_formatter = {
        .opt = { 
		.opt = "l::",
		.format = "-l[P][C][base-time]",
		.description = "show logs. P:show PID, C:show as CSV",
		.handler = opt_handler_log,
	},
	.active = 0,
	.pre_analyze = pre_analyze_log,
	.callback = callback_log,
	.post_analyze = post_analyze_log,
};

static int pid_show=0;
static int csv_char=' ';
static struct timespec start_ts={0,0};
#include <ctype.h>

static int opt_handler_log(int c, char *opt)
{
	if (opt) {
		char * ptr;
		double start;
		while (*opt!='\0') {
			if(*opt == 'P') {
				pid_show=1;
				opt++;
			}else if(*opt == 'C') {
				csv_char=',';
				opt++;
			}else {
				start = strtod(opt,&ptr);
				if (ptr == opt) goto fmt_error;
				opt = ptr;
				start_ts.tv_sec = (long)start;
				start -= (double)start_ts.tv_sec;
				start *= (double)1000*1000*1000;
				start_ts.tv_nsec = (long)start;
			}
		}
	}
	log_formatter.active = 1;
	return 0;
fmt_error:
	return -1;
}

static int pre_analyze_log(struct gate_analyzer *ga)
{
	int n;

	/* build format string */
	if (pid_show) {
		n = snprintf(ga->format_data, sizeof(ga->format_data),
			     "%s%c%s%c%s%c%%s%c%s\n",
			     ga->cols[COL_KEY].format, csv_char,
			     ga->cols[COL_ALIAS].format, csv_char,
			     "%5d", csv_char,
			     csv_char,
			     "%15.9f"); // metric
	} else {
		n = snprintf(ga->format_data, sizeof(ga->format_data),
			     "%s%c%s%c%%s%c%s\n",
			     ga->cols[COL_KEY].format, csv_char,
			     ga->cols[COL_ALIAS].format, csv_char,
			     csv_char,
			     "%15.9f"); // metric
	}

	if (n >= sizeof(ga->format_data))
		return -1; 

	/* if quiet_mode is true, do not print title */
	if (quiet_mode)
		return 0;

	// print title
	printf("%s\n",ga->description);
	printf("%*s%c%*s%c", ga->cols[COL_KEY].width, ga->cols[COL_KEY].title,
	       csv_char, ga->cols[COL_ALIAS].width, ga->cols[COL_ALIAS].title,
	       csv_char);

	if (pid_show) {
		printf("  pid%c%20s%c%15s\n", csv_char, "start[sec]", csv_char,
		       ga->cols[COL_METRIC].title);
	} else {
		printf("%20s%c%15s\n", "start[sec]", csv_char,
		       ga->cols[COL_METRIC].title);
	}

	return 0;
}

static void callback_log(struct gate_analyzer *ga, slot_hkey key,
			 struct timespec *ets, double metric, int pid)
{
	struct timespec ts;
	char buf[64];

	ts = *ets;
	timespec_dec(ts,start_ts);
	if (ts.tv_sec == 0 && ts.tv_nsec < 0)
		sprintf(buf, "        -0.%09ld", -ts.tv_nsec);
	else
		sprintf(buf, "%10ld.%09ld", ts.tv_sec, ts.tv_nsec);

	if (pid_show) {
		printf(ga->format_data, ga->cols[COL_KEY].width, key,
		       ga->cols[COL_ALIAS].width, ga->get_alias(key),
		       pid, buf, metric);
	} else {
		printf(ga->format_data, ga->cols[COL_KEY].width, key,
		       ga->cols[COL_ALIAS].width, ga->get_alias(key),
		       buf, metric);
	}
}

static void post_analyze_log(struct gate_analyzer *ga)
{
	return ;
}

