/*
 LKST statistics formatter

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <lkstla.h>

static int pre_analyze_stat(struct gate_analyzer *ga);
static void callback_stat(struct gate_analyzer *ga, slot_hkey key,
			  struct timespec *ets, double metric, int pid);
static void post_analyze_stat(struct gate_analyzer *ga);
static int opt_handler_stat(int c, char *opt);

static int csv_char=' ';

struct analysis_formatter stat_formatter = {
        .opt = { 
		.opt = "s::",
		.format = "-s[C]",
		.description = "show statistics",
		.handler = opt_handler_stat,
	},
	.active = 0,
	.pre_analyze = pre_analyze_stat,
	.callback = callback_stat,
	.post_analyze = post_analyze_stat,
};

struct stat_data {
	double total, max, min;
	int count;
	int failed;
};

#define SYS_HASH_BITS 6
static generic_slots_t *gsl_stat = NULL;

static int pre_analyze_stat(struct gate_analyzer *ga)
{
	int n;

	gsl_stat = new_generic_slots_sorted(SYS_HASH_BITS, sizeof(struct stat_data));
	if (gsl_stat == NULL) {
		printf("error: fail to memory allocation\n");
		return -1;
	}

	/* build format string */
	n = snprintf(ga->format_data, sizeof(ga->format_data),
		     "%s%c%s%c%%10d%c%%15.9f%c%%15.9f%c%%15.9f%c%%15.9f\n",
		     ga->cols[COL_KEY].format,csv_char,
		     ga->cols[COL_ALIAS].format,csv_char,
		     /*count*/csv_char,/*average*/csv_char,
		     /*max*/csv_char,/*min*/csv_char/*total*/);
	if (n >= sizeof(ga->format_data))
		return -1; 

	if (quiet_mode)
		return 0;

	/* print title */ 
	printf("%s\n",ga->description);
	printf("%*s%c%*s%c%10s%c%15s%c%15s%c%15s%c%15s\n",
	       ga->cols[COL_KEY].width, ga->cols[COL_KEY].title, csv_char,
	       ga->cols[COL_ALIAS].width, ga->cols[COL_ALIAS].title, csv_char,
	       "count",csv_char,"average",csv_char,
	       "max",csv_char,"min",csv_char,"total");

	return 0;
}

static void callback_stat(struct gate_analyzer *ga, slot_hkey key,
			  struct timespec *ets, double metric, int pid)
{
	struct stat_data *stat;
	slot_t *slot;
	slot = find_slot(gsl_stat, key);
	if (slot == NULL) slot = get_free_slot(gsl_stat, key);
	if (slot != NULL)  {
		stat = (struct stat_data *)slot_data(slot);
		stat->total += metric;
		if (stat->max < metric)
			stat->max=metric;
		if (metric < stat->min || 
		    stat->count==0 /*first time*/ )
			stat->min=metric;
		stat->count ++;
	}
}

static void post_analyze_stat(struct gate_analyzer *ga)
{
	slot_hkey key;
	slot_t *slot;
	struct stat_data * stat;

	for_each_sorted_slot(gsl_stat,slot) {
		double avg;
		key = slot->key;
		stat = (struct stat_data *)slot_data(slot);
		avg = stat->total;
		if (stat->count)
			avg /= stat->count;

		printf(ga->format_data,
		       ga->cols[COL_KEY].width, key,
		       ga->cols[COL_ALIAS].width, ga->get_alias(key),
		       stat->count, avg, stat->max, stat->min, stat->total);
	}
	free_generic_slots(gsl_stat);
	return ;
}

static int opt_handler_stat(int c, char *opt)
{
	if (opt) {
		while (*opt!='\0') {
			if (*opt == 'C') {
				csv_char=',';
				opt++;
			}else {
				return -1;
			}
		}
	}
	stat_formatter.active = 1;
	return 0;
}

