 /*
 system information analyzer

 Copyright (C) HITACHI,LTD. 2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by H. Kawai <h-kawai@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <eventdesc.h>
#include <extra_etypes.h>
#include <multientry.h>

int argname_to_index(const char *arg, int etype)
{
	int i;

	if (arg == NULL || *arg == '\0')
		return -1;

	for (i = 0; i < 4; i++) {
		if (!lkst_etype_desc[etype].args[i])
			continue;
		if (!strcmp(lkst_etype_desc[etype].args[i], arg))
			break;
	}

	return (i < 4)? i+1: -1;
}

int get_argidx(const char *arg, int *etype_list)
{
	int idx, idx_max;
	int i;
	char *endp;

	if (!arg)
		return -1;

	for (i = 0; etype_list[i] < LKST_ETYPE_MAX; i++)
		;
	idx_max = i * 4;

	// determine target arg index
	idx = strtol(arg, &endp, 0);
	if (*endp == '\0') {
		if (idx >= 1 && idx <= idx_max)
			return idx;
		else
			goto err;
	}

	idx = -1;
	for (i = 0; i < idx_max / 4; i++) {
		idx = argname_to_index(arg, etype_list[i]);
		if (idx > 0)
			break;
	}
	if (idx < 1)
		goto err;

	return idx + i * 4;

 err:
	return -1;
}
