/*
 scheduler time distribution analyer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <string.h>

static slot_hkey info_key_schedule(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_schedule(struct lkst_log_record *rec);
static char * get_alias_schedule(slot_hkey key);
static ga_type_t get_type_schedule(struct lkst_log_record *rec);
static int init_schedule(void);

static int pid_show=0;
struct gate_analyzer schedule_analyzer;
static int extra_opt_handler_pid(int c, char*v) {
	pid_show = 1;
	SET_COL(schedule_analyzer, COL_ALIAS, "pid", 6, "%*s");

	return 0;
}

static struct command_option pid_option = {
	.opt = "P",
	.format = "-P",
	.description = "show PID instead of task_name",
	.handler = extra_opt_handler_pid,
};

struct gate_analyzer schedule_analyzer = {
	.name = "schedule",
	.description = "scheduler overhead time analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "task_name", 16, "%*s" },
		[COL_METRIC] = { "scheduling-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
		
	.info_key = info_key_schedule,
	.session_key = session_key_schedule,
	.get_alias = get_alias_schedule,

	.get_type = get_type_schedule,

	.init = init_schedule,

	.nr_options = 1,
	.options[0] = &pid_option,
};

static generic_slots_t *gsl_info=NULL;

static int init_schedule(void)
{
	gsl_info = new_generic_slots(5,20);
	if (gsl_info == NULL)return -ENOMEM;
	return 0;
}

static slot_hkey info_key_schedule(struct lkst_log_record *rec_start,
				   struct lkst_log_record *rec)
{
	slot_hkey key = ARG1UL(rec_start);
	slot_t *s;

	s = find_slot(gsl_info, key);
	if (!s)
		s = get_free_slot(gsl_info,key);
	if (s) { 
		if (pid_show) {
			snprintf((char*)slot_data(s),16,"%d",rec_start->posix.log_pid);
		} else {
			memcpy( (char*)slot_data(s), &rec_start->log_arg3, 8);
			memcpy( ((char*)slot_data(s))+8, &rec_start->log_arg4, 8);
			((char*)slot_data(s))[16]='\0';
		}
	}
	return key;
}
static slot_hkey session_key_schedule(struct lkst_log_record *rec)
{
	return rec->posix.log_pid;
}

static char * get_alias_schedule(slot_hkey key)
{
	slot_t *s = find_slot(gsl_info, key);
	if (s) {
		return (char *)slot_data(s);
	}else
		return "(unknown)";
}
static ga_type_t get_type_schedule(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_PROCESS_SCHED_ENTER:
		return GAT_START;
	case LKST_ETYPE_PROCESS_SCHED_EXIT:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
