/*
 spinlock delay distribution analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <ksymbols.h>
#include <logfile.h>

static slot_hkey info_key_spinlock(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static char * get_alias_spinlock(slot_hkey key);
static ga_type_t get_type_spinlock(struct lkst_log_record *rec);
static slot_hkey session_key_spinlock(struct lkst_log_record *rec);

static generic_slots_t *gsl_info = NULL;

static int lock_show = 0;
struct gate_analyzer spinlock_analyzer;
static int extra_opt_handler_lock(int c, char*v) {
	lock_show = 1;
	SET_COL(spinlock_analyzer, COL_ALIAS, "spinlock", 32, "%*s");

	return 0;
}

static struct command_option lock_option = {
	.opt = "L",
	.format = "-L",
	.description = "show Spinlock instead of call_address",
	.handler = extra_opt_handler_lock,
};

#define MAX_ADNAME 31
#define MAX_FNNAME 22

static int init_spinlock(void)
{
	int ret;
	if ((ret = init_ksymbols()) <0) return ret;
	gsl_info = new_generic_slots(5,MAX_ADNAME+1);
	if (gsl_info == NULL)return -ENOMEM;
	return 0;
}

struct gate_analyzer spinlock_analyzer = {
	.name = "spinlock",
	.description = "spinlock locking time analyzer",
	.cols = {
		[COL_KEY] = { "address", ADDR_LEN, "%0*lx" },
		[COL_ALIAS] = { "calling_point", 32, "%*s" },
		[COL_METRIC] = { "locking-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TO1_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID
		
	.info_key = info_key_spinlock,
	.session_key = session_key_spinlock,
	.get_alias = get_alias_spinlock,

	.get_type = get_type_spinlock,

	.init = init_spinlock,

	.nr_options = 2,
	.options = {&ksym_option,&lock_option},
};

static slot_hkey session_key_spinlock(struct lkst_log_record *rec)
{
	return XORL(rec->log_arg2, rec->posix.log_pid);
}

static slot_hkey info_key_spinlock(struct lkst_log_record *rec_start,
				   struct lkst_log_record *rec)
{
	slot_hkey key = ARG1UL(rec_start);
	if (lock_show )
		key = ARG2UL(rec_start);
	if (find_slot(gsl_info, key) == NULL) {
		slot_t *s,*p;
		char buf[MAX_FNNAME+1]="";

		p = get_free_slot(gsl_info,key);
		s = get_symbol_slot(key);
		if (p) { 
			if (s) strncpy(buf, (char*)slot_data(s),MAX_FNNAME);
			buf[MAX_FNNAME] = '\0';
			snprintf((char*)slot_data(p), MAX_ADNAME,
				 "%s+%lx", buf, p->key-s->key);
		}
	}
	return key;
}

static char * get_alias_spinlock(slot_hkey key)
{
	slot_t *s = find_slot(gsl_info, key);
	if (s) {
		return (char *)slot_data(s);
	} else
		return "(unknown)";
}

static ga_type_t get_type_spinlock(struct lkst_log_record *rec)
{
	switch (rec->posix.log_event_type) {
	case LKST_ETYPE_LK_SPINTRYLOCK:
		if (ARG3UL(rec) == 0)
			break;
		// fall through
	case LKST_ETYPE_LK_SPINLOCK:
		return GAT_START;
	case LKST_ETYPE_LK_SPINUNLOCK:
		return GAT_END;
	}
	return GAT_IGNORE;
}
