/*
 syscall time distribution analyer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>
#include <syscalls.h>
#include <extra_etypes.h>

static slot_hkey info_key_syscall(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_syscall(struct lkst_log_record *rec);
static char * get_alias_syscall(slot_hkey key);
static ga_type_t get_type_syscall(struct lkst_log_record *rec);

extern struct gate_analyzer syscall_analyzer;
static int show_systime=0;
static int extra_opt_handler_systime(int c, char*v) {
	show_systime = 1;
	SET_COL(syscall_analyzer, COL_METRIC, "system-time", 0, "");
	return 0;
}

static struct command_option systime_option = {
	.opt = "T",
	.format = "-T",
	.description = "show system time instead of real time",
	.handler = extra_opt_handler_systime,
};

struct gate_analyzer syscall_analyzer = {
	.name = "syscall",
	.description = "System call analyzer",
	.cols = {
		[COL_KEY] = { "sysno", 5, "%*d" },
		[COL_ALIAS] = { "syscall_name", 18, "%*s" },
		[COL_METRIC] = { "processing-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TON_SESSION
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_syscall,
	.session_key = session_key_syscall,
	.get_alias = get_alias_syscall,
	.get_type = get_type_syscall,

	.init = init_none,
	.nr_options = 1,
	.options = {&systime_option},
};

static slot_hkey info_key_syscall(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return (slot_hkey)(rec_start->log_arg1);
}
static slot_hkey session_key_syscall(struct lkst_log_record *rec)
{
	if (rec->posix.log_event_type == LKST_ETYPE_PROCESS_CONTEXTSW2) {
		return (slot_hkey)(rec->log_arg1);
	}
	return (slot_hkey)(rec->posix.log_pid);
}

static char * get_alias_syscall(slot_hkey key)
{
	if (key > NR_syscalls || syscall_name[key]==NULL)
		return "(unknown)";
	else 
		return syscall_name[key];
}

#define LKST_ETYPE_SYSCALL_SYSENTER 0x32
#define LKST_ETYPE_SYSCALL_SYSEXIT 0x33

static ga_type_t get_type_syscall(struct lkst_log_record *rec)
{
	switch(rec->posix.log_event_type) {
	case LKST_ETYPE_SYSCALL_ENTRY:
	case LKST_ETYPE_SYSCALL_SYSENTER:
		return GAT_START;
	case LKST_ETYPE_SYSCALL_EXIT:
	case LKST_ETYPE_SYSCALL_SYSEXIT:
		return GAT_END;
	case LKST_ETYPE_PROCESS_CONTEXTSWITCH:
		if(show_systime)
			return GAT_PAUSE;
	case LKST_ETYPE_PROCESS_CONTEXTSW2:
		if(show_systime)
			return GAT_RESUME;
	default:
		return GAT_IGNORE;
	}
}
