/*
 Page vmscan analyzer

 Copyright (C) HITACHI,LTD. 2004-2005
 WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
  
 The development of this program is partly supported by IPA
 (Information-Technology Promotion Agency, Japan).
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <errno.h>
#include <linux/lkst.h>
#include <linux/lkst_buffer.h>
#include <lkstla.h>

static slot_hkey info_key_vmscan(struct lkst_log_record *rec_start, struct lkst_log_record *rec_end);
static slot_hkey session_key_vmscan(struct lkst_log_record *rec);
static char * get_alias_vmscan(slot_hkey key);
static ga_type_t get_type_vmscan(struct lkst_log_record *rec);

struct gate_analyzer vmscan_analyzer = {
	.name = "vmscan",
	.description = "page aging/recliming analyzer",
	.cols = {
		[COL_KEY] = { "type", 4, "%*d" },
		[COL_ALIAS] = { "vmscan-method", 14, "%*s" },
		[COL_METRIC] = { "processing-time" },
	},

	GA_INIT_SESSION_ANALYZER
	GA_INIT_1TO1_SESSION
	GA_INIT_NO_EXTRAOPTS
	GA_INIT_RET_SESSION_TIME
	GA_INIT_RET_EVENT_PID

	.info_key = info_key_vmscan,
	.session_key = session_key_vmscan,
	.get_alias = get_alias_vmscan,

	.get_type = get_type_vmscan,

	.init = init_none,
};

static char *vmscan_name[] = {
	[0]="shrink_slab",
	[1]="shrink_cache",
	[2]="page_aging",
	[3]="page_reclaim",
};
#define NR_vmscans 4

static slot_hkey info_key_vmscan(struct lkst_log_record *rec_start, struct lkst_log_record *rec)
{
	return ((rec->posix.log_event_type&0xfe) - 
		LKST_ETYPE_SHRINK_SLAB_ENTER) >> 1;
}
static slot_hkey session_key_vmscan(struct lkst_log_record *rec)
{
	return (((rec->posix.log_pid & 0x7fffff)<<8) | 
		(rec->posix.log_event_type & 0xfe));
}

static char * get_alias_vmscan(slot_hkey key)
{
	if(key>=NR_vmscans)
		return "(unknown)";
	else
		return vmscan_name[key];
}

static ga_type_t get_type_vmscan(struct lkst_log_record *rec)
{
	switch( rec->posix.log_event_type) {
	case LKST_ETYPE_SHRINK_SLAB_ENTER:
	case LKST_ETYPE_SHRINK_CACHE_ENTER:
	case LKST_ETYPE_PAGE_AGING_ENTER:
	case LKST_ETYPE_PAGE_RECLAIM_ENTER:
		return GAT_START;
	case LKST_ETYPE_SHRINK_SLAB_EXIT:
	case LKST_ETYPE_SHRINK_CACHE_EXIT:
	case LKST_ETYPE_PAGE_AGING_EXIT:
	case LKST_ETYPE_PAGE_RECLAIM_EXIT:
		return GAT_END;
	default:
		return GAT_IGNORE;
	}
}
