/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>

extern _command_t ia64_cmdset[];

/* Function prototypes
 */
void dis_init(FILE *);

int
arch_init(FILE *ofp)
{
	dis_init(ofp);
	return(register_cmds(ia64_cmdset));
}

/* Architecture specific print routines. This allows commands to print out
 * arch dependant values such as kernel addresses, from within the arch
 * independant section of lcrash. 
 */

/*
 * print_kaddr()
 *
 * Print out a kernel address. Note that there is no leading "0x", to 
 * allow for more flexibility.
 */
void
print_kaddr(kaddr_t kaddr, FILE *ofp, int flag)
{
	if (flag == 1) {
		fprintf(ofp, "%#18"FMTPTR"x", kaddr);
	} else if (flag == 2) {
		fprintf(ofp, "%#018"FMTPTR"x", kaddr);
	} else {
		fprintf(ofp, "%#"FMTPTR"x", kaddr);
	}
}
