/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>
#include <dlfcn.h>

/*
 * ldcmds_cmd()
 */
int
ldcmds_cmd(command_t *cmd)
{
	void *dl_hndl;
	char *error;
	_command_t *cmdset;

	if (!(dl_hndl = dlopen(cmd->args[0], RTLD_LAZY))) {
		error = dlerror();
		fprintf(KL_ERRORFP, "     : %s\n", error);
		return(1);
	}
	cmdset = dlsym(dl_hndl, "cmdset");
	if ((error = dlerror())) {
		fprintf(KL_ERRORFP, "     : %s\n", error);
		dlclose(dl_hndl);
		return(1);
	}
	register_cmds(cmdset);
	return(0);
}

#define _LDCMDS_USAGE "cmd_library"

/*
 * ldcmds_usage() 
 */
void
ldcmds_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _LDCMDS_USAGE);
}

/*
 * ldcmds_help() -- Print the help information for the 'ldcmds' command.
 */
void
ldcmds_help(command_t *cmd)
{
	CMD_HELP(cmd, _LDCMDS_USAGE,
		"Dynamically load a library of lcrash commands.");
}

/*
 * ldcmds_parse() -- Parse the command line arguments for 'ldcmds'.
 */
int
ldcmds_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, C_TRUE, 0)) {
		return(1);
	}
	return(0);
}

/*
 * ldcmds_complete() -- Complete arguments of 'ldcmds' command.
 */
char *
ldcmds_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((cmd->nargs == 1)) {
		return(complete_file_name(cmd->args[cmd->nargs -1], 100));
	}
	fprintf(cmd->ofp, "\n");
	ldcmds_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
