/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#define STACK_SEGMENTS	1
#define STACK_SIZE	0x2000

#ifdef NOT
#define INCLUDE_REGINFO 1
#endif

#ifdef INCLUDE_REGINFO

#define NUM_REGS	8	
#define REGVAL_UNKNOWN  0
#define REGVAL_VALID    1
#define REGVAL_BAD      2  /* Value loaded into register before it was saved */

/* Register record
 */
typedef struct reg_rec {
	uint32_t			state;
	uint32_t			value;
} reg_rec_t;
#endif

/* Stack frame
 */
typedef struct sframe_rec {
	struct sframe_rec      *next;
	struct sframe_rec      *prev;
	int			flag;
	int			level;
	char		       *funcname;
	char		       *srcfile;
	int			line_no;
	kaddr_t			pc;
	kaddr_t			ra;
	kaddr_t			sp;
	kaddr_t			fp;
	uint32_t	       *asp;
	int			frame_size;
	int			ptr;
	uint64_t		error;
#ifdef INCLUDE_REGINFO
	reg_rec_t		regs[NUM_REGS];
#endif
} sframe_t;

/* flag field of sframe_t */
#define EX_FRAME	0x1	/* this frame is an interrupt or exception 
				   frame, pt_regs field of sframe_t is valid 
				   in this case */

/* Stack segment structure
 */
struct stack_s {
	int			type;
	uint32_t		size;
	kaddr_t			addr;
	uint32_t	       *ptr;
};

/* Stack trace header
 */
typedef struct trace_rec {
	int			flags;
	kaddr_t			task;
	struct task_struct     *tsp;
	struct stack_s		stack[STACK_SEGMENTS];
	int			stackcnt;
	sframe_t	       *frame;
	int			nframes;
} trace_t;

#define TF_TRACEREC_VALID  0x01 /* The trace_rec_s has been setup already!   */
#define TF_SUPPRESS_HEADER 0x02 /* Suppress header output from trace cmds    */

/* Stack types 
 */
#define S_USERSTACK	0
#define S_KERNELSTACK	1

/* Stack frame updating macro
 */
#define UPDATE_FRAME(FUNCNAME, PC, RA, SP, FP, ASP, SRCNAME, LINE_NO, SIZE, FLAG) \
        curframe->funcname = FUNCNAME; \
        curframe->pc = PC; \
        curframe->sp = SP; \
        curframe->ra = RA; \
        curframe->fp = FP; \
        curframe->asp = ASP; \
        curframe->srcfile = SRCNAME; \
        curframe->line_no = LINE_NO; \
        curframe->frame_size = SIZE; \
        curframe->ptr = curstkidx; \
        kl_enqueue((element_t **)&trace->frame, (element_t *)curframe); \
        trace->nframes++; \
	curframe->flag |= FLAG; \

/* Function prototypes
 */
void print_pc(
	kaddr_t 	/* PC */, 
	FILE *		/* output file pointer */);

trace_t *alloc_trace_rec(
	int 		/* flag */);

int setup_trace_rec(kaddr_t, kaddr_t, int, trace_t *);
int find_trace(kaddr_t, kaddr_t, kaddr_t, kaddr_t, trace_t *, int);
void trace_banner(FILE *);
int print_traces(kaddr_t, int, int, FILE *);
void print_trace(trace_t *, int, FILE *);
void free_trace_rec(trace_t *t);
int task_trace(kaddr_t, int, FILE *);
int do_list(kaddr_t, int, FILE *);
void live_vmdump(int, int);
int do_report(int, FILE *);
void stab_type_banner(FILE *, int);
void ktype_banner(FILE *, int);
void print_stab_type(stab_type_t *, int, FILE *);
void print_ktype(kltype_t *, int, FILE *);
void walk_ktype(kltype_t *, int, FILE *);
int list_stab_types(int, FILE *);
int list_ktypes(int, FILE *);
void structlist(FILE *);
int walk_structs(char *, char *, int, kaddr_t, int, FILE *);
sframe_t *alloc_sframe(trace_t *, int);
int add_frame(trace_t *, kaddr_t, kaddr_t);
void finish_trace(trace_t *);
int dumptask_trace(kaddr_t, dump_header_asm_t *, int, FILE *);
