/*-*-c++-*-
 * $Id: cprintexprdialog.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CPRINTEXPRDIALOG_H
#define CPRINTEXPRDIALOG_H

#include <qdialog.h>

class QComboBox;
class QLabel;
class QPushButton;
class QFrame;
class QLineEdit;

/**
  *@author Michael Geselbracht
  */

class CPrintExprDialog : public QDialog {
   Q_OBJECT

public:
	CPrintExprDialog(const QString& label, QWidget* parent=0, const char* name = 0);
	~CPrintExprDialog();
	
	/* Remove the first line of the combo box
	*/
	void removeLastInput();
	
	/* Return the current text.
	*/
	QString text() const;
	
	/* Return number of elements.
	*/
	int count() const;
	
	void setText(const QString& str, bool rewindCursor=false);

protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual bool eventFilter(QObject* obj, QEvent* e);
	
protected slots:
	void slotOk();
	void slotCancel();

protected:
	QComboBox* oBox;
		
private:
	QFrame* oTopFrame;
	QFrame* oBotFrame;
	QLabel* oLabel;
	QLabel* oCountLabel;
	QPushButton* oOk;
	QPushButton* oCancel;
	QLineEdit* oCount;
};

#endif
