/*-*-c++-*-
 * $Id: ctraceitem.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTRACEITEM_H
#define CTRACEITEM_H


/**Contains level, function, offset and address of a trace output from lcrash
  *@author Michael Geselbracht
  */

class CTraceItem {
public: 
	CTraceItem() { }
	~CTraceItem() { }
	
	inline const QString& level() const {
		return oLevel;
	}
	inline void setLevel(const QString& lvl) {
		oLevel = lvl;
	}
	inline const QString& function() const {
		return oFunction;
	}
	inline void setFunction(const QString& fkt) {
		oFunction = fkt;
	}
	inline const QString& offset() const {
		return oOffset;
	}
	inline void setOffset(const QString& x) {
		oOffset = x;
	}
	inline const QString& address() const {
		return oAddress;
	}
	inline void setAddress(const QString& addr) {
		oAddress = addr;
	}
	
private:
	QString oLevel;
	QString oFunction;
	QString oOffset;
	QString oAddress;
};

#endif
