/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002-2003 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/
#ifndef _LKST_MASKSET_H_
#define _LKST_MASKSET_H_

#include "command.h"

int lkst_maskset_getid(int fd, const char *name);

void maskset_getid(const char *name );
void maskset_get_uniqname(char *buf, const char *prefix, int size);
void maskset_list(void);
void maskset_read(lkst_maskset_id id, const char * name, 
		  int all, int disp);
void maskset_read_all(int all, int disp);
void maskset_set(lkst_maskset_id id, const char *name);
void maskset_write(lkst_maskset_id *id, const char *file_name,
		   const char *maskset_name);
void maskset_delete(lkst_maskset_id id, const char *name);
void maskset_config(lkst_maskset_id id, const char *name,
		    int	event_type, lkst_evhandler_id evhandler_id);

#endif
