/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>

static int dump_level = DUMP_LEVEL_ALL;

void live_dump(int, int);

/*
 * livedump_cmd() -- Run the 'livedump' command.
 */
int
livedump_cmd(command_t *cmd)
{
	live_dump(dump_level, 1);
	return(0);
}

#define _LIVEDUMP_USAGE "[-l level]"

/*
 * livedump_usage() -- Print the usage string for the 'livedump' command.
 */
void
livedump_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _LIVEDUMP_USAGE);
}

/*
 * livedump_help() -- Print the help information for the 'livedump' command.
 */
void
livedump_help(command_t *cmd)
{
	CMD_HELP(cmd, _LIVEDUMP_USAGE,
        "Create a system dump from live system memory.");
}

/*
 * livedump_parse() -- Parse the command line arguments for 'livedump'.
 */
int
livedump_parse(command_t *cmd)
{
	option_t *op;

	if (set_cmd_flags(cmd, 0, "l:b:")) {
		return(1);
	}
	op = cmd->options;
	while (op) {
		switch(op->op_char) {
			case 'l':
				dump_level = atoi(op->op_arg);
				break;
		}
		op = op->op_next;
	}
	return(0);
}

/*
 * livedump_complete() -- Complete arguments of 'livedump' command.
 */
char *
livedump_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	livedump_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
