/*-*-c++-*-
 * $Id: chelpabout.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "chelpabout.h"

#include <qframe.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qapplication.h>

#ifndef WIN32
#include <sys/utsname.h>
#else
#include "osdep.h"
#endif

#include "crashtypes.h"
#include "resourceadapter.h"

CHelpAbout::CHelpAbout(QWidget *parent, const char *name ) : QDialog(parent, name, true)
{
	setFixedSize(450, 300);
	
	QFrame* top = new QFrame(this);
	top->setFrameStyle(QFrame::Panel | QFrame::Raised);
	QFrame* bot = new QFrame(this);
	bot->setFrameStyle(QFrame::Panel | QFrame::Raised);
	
	QLabel* logo = new QLabel(top);

	setCaption(tr("About QLcrash ") + VERSION);
	setIcon(Resource::getBitmap(IDR_PNG7));
	logo->setPixmap(Resource::getBitmap(IDR_PNG2));
	logo->setAutoResize(true);
	logo->update();
	logo->move(10, 10);
	
	QLabel* version = new QLabel("<QT><B>Version " VERSION "</B></QT>", top);
	version->resize(width() - logo->width() - 30, 20);
	version->setAlignment(AlignCenter);

	// get platform info
	struct utsname uts;
	uname(&uts);
	
	QLabel* kernel = new QLabel(QString("%1 %2").arg(uts.sysname)
		.arg(uts.release), top);
	kernel->resize(version->size());
	kernel->setAlignment(AlignCenter);
	
	QLabel* machine = new QLabel(QString("on ") + (const char *)uts.machine, top);
	machine->resize(version->size());
	machine->setAlignment(AlignCenter);

	QLabel* legal = new QLabel(
		"<QT><SMALL><NOBR>Copyright 2001 IBM Deutschland Entwicklung GmbH</NOBR></SMALL></QT>",
		top
	);
	legal->setAutoResize(true);
	legal->update();
	
	QPushButton* close = new QPushButton(qApp->translate("CHelpAbout", "Close"), bot);
	close->setDefault(true);
	
	// layout
	logo->move(10, 10);
	version->move(logo->x() + logo->width() + 10, logo->y() + 10);
	kernel->move(version->x(), version->y() + version->height() + 10);
	machine->move(kernel->x(), kernel->y() + kernel->height());
	legal->move(10, logo->y() + logo->height() + 5);
	close->move(width()/2 - close->width()/2, 5);
	top->setGeometry(0, 0, width(), logo->height() + legal->height() + 25);
	bot->setGeometry(0, top->y() + top->height(), width(), close->height() + 10);
	setFixedSize(width(), top->height() + bot->height());

	connect(close, SIGNAL(clicked()), SLOT(accept()));
}

CHelpAbout::~CHelpAbout()
{
}
