/*-*-c++-*-
 * $Id: ctracelowcore.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "ctracelowcore.h"

#include <qtimer.h>

#include <ctype.h>
#include <utility>

using namespace std;

CTraceLowcore::CTraceLowcore(QWidget* parent, const char* name) : QTextView(parent, name)
{
	setMinimumSize(200, 100);
	setWFlags(getWFlags() | WDestructiveClose);
}

CTraceLowcore::~CTraceLowcore()
{
}

bool
CTraceLowcore::eventFilter(QObject* obj, QEvent* e)
{
	if (e->type() == QEvent::Close) {
		close();
	}
	
	return QTextView::eventFilter(obj, e);
}

void
CTraceLowcore::setContent(const CLowcoreList& cont)
{
	QString text;
	CLowcoreList::ConstIterator it = cont.begin();
	
	while (it != cont.end()) {
		text += (*it).first + ':';
		
		const QStringList& token = (*it).second;
		if (token.count() > 2U) {
			text += "\n\t";
		}
		else {
			text += '\t';
		}
		
		int n = 0;
		QStringList::ConstIterator sit = token.begin();
		bool digit = isdigit((*sit).at(0).latin1());
		
		while (sit != token.end()) {
			text += *sit + ' ';
			++sit;
			
			if (digit && ++n == 4 && sit != token.end()) {
				text += "\n\t";
				n = 0;
			}
		}
		
		text += '\n';
		
		++it;
	}
	
	setText(text);
}
