#!/bin/sh
# LKST release package script
# COPYRIGHT (C) HITACHI,LTD. 2003 ALL RIGHTS RESERVED. 
# Written by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
# Usage: scripts/release [clean]
# !WARNIG!: you should check following 2 points before using this script.
# 1. Make sure that /usr/src/linux points the kernel patched release-version patches of LKST.
# 2. Make sure that you can build rpm packages.

[ -z "$RELDIR" ] && RELDIR=Releases
LOGFILE=$RELDIR/release.log

if [ "$1" = clean ] ; then
	echo -n "cleaning up ..."
	make distclean &> /dev/null
	rm -rf $RELDIR
	echo "done"
	exit 0
fi

[ -e $RELDIR ] && echo "$RELDIR already exists, abort." && exit 1

mkdir $RELDIR
eval `grep ^VERSION Makefile | tr -d " " ` 

echo -n "compressing patches ..."
( cp linux26.patch $RELDIR/lkst-$VERSION.linux26.patch ;
#  cp lkcd-addon/*.patch ./$RELDIR ;
  cp hooks/*.patch ./$RELDIR ;
  cp extra-patch/*.patch ./$RELDIR ;
  gzip -f $RELDIR/*.patch 
  ) &> $LOGFILE
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

echo -n "converting documents ..."
( nkf --windows Install > $RELDIR/Install-$VERSION.txt
  nkf --windows howto.txt > $RELDIR/Howto-$VERSION.txt
  nkf --windows changelog > $RELDIR/Changelog-$VERSION.txt
  ) >> $LOGFILE 2>&1
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

echo -n "configuring packages ..."
make config KSRC=/usr/src/linux >> $LOGFILE  2>&1
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

echo -n "packaging lkstutils ..."
( cd command
  make dist
  mv lkstutils-*.tar.gz ../$RELDIR/
  ) >> $LOGFILE 2>&1
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

echo -n "packaging lkstaddons ..."
( cd addons
  make dist
  mv lkstaddons-*.tar.gz ../$RELDIR/
  ) >> $LOGFILE 2>&1
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

echo -n "building the rpm package of lkstutils ..."
( export LANG=C
  echo See $RELDIR/rpm.log
  rpmbuild -ta $RELDIR/lkstutils-*.tar.gz &> $RELDIR/rpm.log
  [ $? -eq 0 ] && mv `grep ^Wrote $RELDIR/rpm.log | cut -d" " -f2 ` $RELDIR
 ) >> $LOGFILE 2>&1
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

echo -n "packaging lkst ..."
make dist >> $LOGFILE 2>&1
mv lkst-*.tar.gz $RELDIR/
if [ $? -ne 0 ]; then echo "failed" ; exit 1; fi
echo "done"

