/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.main.FreeMindMain;
import freemind.modes.LinkRegistryAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.browsemode.BrowseNodeModel;
import freemind.modes.browsemode.BrowseXMLElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlException;

public class BrowseMapModel
extends MapAdapter {
    private URL url;
    private LinkRegistryAdapter linkRegistry;

    public BrowseMapModel(FreeMindMain frame) {
        this(null, frame);
    }

    public BrowseMapModel(BrowseNodeModel root, FreeMindMain frame) {
        super(frame);
        if (root != null) {
            this.setRoot(root);
        } else {
            this.setRoot(new BrowseNodeModel(this.getFrame().getResources().getString("new_mindmap"), this.getFrame()));
        }
        this.linkRegistry = new LinkRegistryAdapter();
    }

    public MindMapLinkRegistry getLinkRegistry() {
        return this.linkRegistry;
    }

    public String toString() {
        if (this.getURL() == null) {
            return null;
        }
        return this.getURL().toString();
    }

    public File getFile() {
        return null;
    }

    protected void setFile() {
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL v) {
        this.url = v;
    }

    public boolean save(File file) {
        return true;
    }

    public boolean isSaved() {
        return true;
    }

    public void load(File file) throws FileNotFoundException {
        throw new FileNotFoundException();
    }

    public void load(URL url) throws Exception {
        this.setURL(url);
        BrowseNodeModel root = this.loadTree(url);
        if (root == null) {
            throw new Exception();
        }
        this.setRoot(root);
    }

    BrowseNodeModel loadTree(URL url) {
        BrowseNodeModel root = null;
        BrowseXMLElement mapElement = new BrowseXMLElement(this.getFrame());
        InputStreamReader urlStreamReader = null;
        Object uc = null;
        try {
            urlStreamReader = new InputStreamReader(url.openStream());
        }
        catch (AccessControlException ex) {
            this.getFrame().getController().errorMessage("Could not open URL " + url.toString() + ". Access Denied.");
            System.err.println(ex);
            return null;
        }
        catch (Exception ex) {
            this.getFrame().getController().errorMessage("Could not open URL " + url.toString() + ".");
            System.err.println(ex);
            return null;
        }
        try {
            mapElement.parseFromReader(urlStreamReader);
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
        mapElement.processUnfinishedLinks(this.getLinkRegistry());
        root = (BrowseNodeModel)mapElement.getMapChild();
        return root;
    }
}

