/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.modes.LinkAdapter;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapNode;
import java.awt.Point;

public abstract class ArrowLinkAdapter
extends LinkAdapter
implements MindMapArrowLink {
    protected Point startInclination;
    protected Point endInclination;
    protected String startArrow = "None";
    protected String endArrow = "Default";

    public ArrowLinkAdapter(MindMapNode source, MindMapNode target, FreeMindMain frame) {
        super(source, target, frame, "standardlinkcolor", "standardlinkstyle");
    }

    public Point getStartInclination() {
        return this.startInclination;
    }

    public Point getEndInclination() {
        return this.endInclination;
    }

    public String getStartArrow() {
        return this.startArrow;
    }

    public String getEndArrow() {
        return this.endArrow;
    }

    public void setStartInclination(Point startInclination) {
        this.startInclination = startInclination;
    }

    public void setEndInclination(Point endInclination) {
        this.endInclination = endInclination;
    }

    public void setStartArrow(String startArrow) {
        if (startArrow == null || startArrow.toUpperCase().equals("NONE")) {
            this.startArrow = "None";
            return;
        }
        if (startArrow.toUpperCase().equals("DEFAULT")) {
            this.startArrow = "Default";
            return;
        }
        System.err.println("Cannot set the start arrow type to " + startArrow);
    }

    public void setEndArrow(String endArrow) {
        if (endArrow == null || endArrow.toUpperCase().equals("NONE")) {
            this.endArrow = "None";
            return;
        }
        if (endArrow.toUpperCase().equals("DEFAULT")) {
            this.endArrow = "Default";
            return;
        }
        System.err.println("Cannot set the end arrow type to " + endArrow);
    }

    public Object clone() {
        ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)super.clone();
        arrowLink.startInclination = this.startInclination == null ? null : new Point(this.startInclination.x, this.startInclination.y);
        arrowLink.endInclination = this.endInclination == null ? null : new Point(this.endInclination.x, this.endInclination.y);
        arrowLink.startArrow = this.startArrow == null ? null : new String(this.startArrow);
        arrowLink.endArrow = this.endArrow == null ? null : new String(this.endArrow);
        return arrowLink;
    }
}

