/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Font;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class NodeAdapter
implements MindMapNode {
    protected Object userObject = "no text";
    private String link = null;
    protected String style;
    protected Vector icons = new Vector();
    protected MindMapCloud cloud;
    protected Color color;
    protected boolean folded;
    private Tools.BooleanHolder left;
    protected List children;
    private MindMapNode preferredChild;
    protected Font font;
    protected boolean underlined = false;
    private MindMapNode parent;
    private MindMapEdge edge;
    private NodeView viewer = null;
    private FreeMindMain frame;
    private static final boolean ALLOWSCHILDREN = true;
    private static final boolean ISLEAF = false;

    protected NodeAdapter(FreeMindMain frame) {
        this.frame = frame;
    }

    protected NodeAdapter(Object userObject, FreeMindMain frame) {
        this.userObject = userObject;
        this.frame = frame;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public NodeView getViewer() {
        return this.viewer;
    }

    public void setViewer(NodeView viewer) {
        this.viewer = viewer;
    }

    public TreePath getPath() {
        Vector pathVector = new Vector();
        this.addToPathVector(pathVector);
        TreePath treePath = new TreePath(pathVector.toArray());
        return treePath;
    }

    public MindMapEdge getEdge() {
        return this.edge;
    }

    public void setEdge(MindMapEdge edge) {
        this.edge = edge;
    }

    public MindMapCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(MindMapCloud cloud) {
        this.cloud = cloud;
    }

    public String getStyle() {
        if (this.style == null) {
            if (this.isRoot()) {
                return this.getFrame().getProperty("standardnodestyle");
            }
            return this.getParentNode().getStyle();
        }
        return this.style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void estabilishOwnFont() {
        this.font = this.font != null ? this.font : this.getFrame().getController().getDefaultFont();
    }

    public void setBold(boolean bold) {
        if (bold != this.isBold()) {
            this.toggleBold();
        }
    }

    public void toggleBold() {
        this.estabilishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle() ^ 1, this.font.getSize())));
    }

    public void setItalic(boolean italic) {
        if (italic != this.isItalic()) {
            this.toggleItalic();
        }
    }

    public void toggleItalic() {
        this.estabilishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle() ^ 2, this.font.getSize())));
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public MindMapNode getParentNode() {
        return this.parent;
    }

    public void setFontSize(int fontSize) {
        this.estabilishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle(), fontSize)));
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontSize() {
        if (this.getFont() != null) {
            return new Integer(this.getFont().getSize()).toString();
        }
        return this.getFrame().getProperty("defaultfontsize");
    }

    public String getFontFamilyName() {
        if (this.getFont() != null) {
            return this.getFont().getFamily();
        }
        return this.getFrame().getProperty("defaultfont");
    }

    public boolean isBold() {
        return this.font != null ? this.font.isBold() : false;
    }

    public boolean isItalic() {
        return this.font != null ? this.font.isItalic() : false;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public boolean isFolded() {
        return this.folded;
    }

    public Vector getIcons() {
        return this.icons;
    }

    public void addIcon(MindIcon _icon) {
        this.icons.add(_icon);
    }

    public int removeLastIcon() {
        if (this.icons.size() > 0) {
            this.icons.setSize(this.icons.size() - 1);
        }
        return this.icons.size();
    }

    public boolean hasFoldedStrictDescendant() {
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            NodeAdapter child = (NodeAdapter)e.next();
            if (!child.isFolded() && !child.hasFoldedStrictDescendant()) continue;
            return true;
        }
        return false;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    protected MindMapNode basicCopy() {
        return null;
    }

    public MindMapNode shallowCopy() {
        MindMapNode copy = this.basicCopy();
        copy.setColor(this.getColor());
        copy.setFont(this.getFont());
        copy.setLink(this.getLink());
        if (this.isLeft() != null) {
            copy.setLeft(this.isLeft().getValue());
        }
        Vector icons = this.getIcons();
        for (int i = 0; i < icons.size(); ++i) {
            copy.addIcon((MindIcon)icons.get(i));
        }
        return copy;
    }

    public String toString() {
        String string = this.userObject.toString();
        return string;
    }

    public boolean isDescendantOf(MindMapNode node) {
        if (this.isRoot()) {
            return false;
        }
        if (node == this.getParentNode()) {
            return true;
        }
        return this.getParentNode().isDescendantOf(node);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public int getChildPosition(MindMapNode childNode) {
        int position = 0;
        ListIterator i = this.children.listIterator();
        while (i.hasNext()) {
            if ((MindMapNode)i.next() == childNode) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public ListIterator childrenUnfolded() {
        return this.children != null ? this.children.listIterator() : Collections.EMPTY_LIST.listIterator();
    }

    public ListIterator childrenFolded() {
        if (this.isFolded()) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return this.childrenUnfolded();
    }

    public Enumeration children() {
        throw new UnsupportedOperationException("Use childrenFolded or childrenUnfolded instead");
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.isFolded()) {
            return null;
        }
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf((MindMapNode)node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Tools.BooleanHolder isLeft() {
        return this.left;
    }

    public void setLeft(boolean isLeft) {
        if (this.left == null) {
            this.left = new Tools.BooleanHolder();
        }
        this.left.setValue(isLeft);
    }

    public void insert(MutableTreeNode child, int index) {
        if (index < 0) {
            index = this.getChildCount();
            this.children.add(index, child);
        } else {
            this.children.add(index, child);
            this.preferredChild = (MindMapNode)child;
        }
        child.setParent(this);
    }

    public void remove(int index) {
        MutableTreeNode node = (MutableTreeNode)this.children.get(index);
        if (node == this.preferredChild) {
            this.preferredChild = this.children.size() > index + 1 ? (MindMapNode)this.children.get(index + 1) : (index > 0 ? (MindMapNode)this.children.get(index - 1) : null);
        }
        node.setParent(null);
        this.children.remove(index);
    }

    public void remove(MutableTreeNode node) {
        if (node == this.preferredChild) {
            int index = this.children.indexOf(node);
            this.preferredChild = this.children.size() > index + 1 ? (MindMapNode)this.children.get(index + 1) : (index > 0 ? (MindMapNode)this.children.get(index - 1) : null);
        }
        node.setParent(null);
        this.children.remove(node);
    }

    public MindMapNode getPreferredChild() {
        if (this.children.contains(this.preferredChild)) {
            return this.preferredChild;
        }
        if (!this.isLeaf()) {
            return (MindMapNode)this.children.get((this.getChildCount() + 1) / 2 - 1);
        }
        return null;
    }

    public void setPreferredChild(MindMapNode node) {
        this.preferredChild = node;
        if (node == null) {
            return;
        }
        if (this.parent != null) {
            this.parent.setPreferredChild(this);
        }
    }

    public void removeFromParent() {
        this.parent.remove(this);
    }

    public void setParent(MutableTreeNode newParent) {
        this.parent = (MindMapNode)newParent;
    }

    public void setParent(MindMapNode newParent) {
        this.parent = newParent;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    private void addToPathVector(Vector pathVector) {
        pathVector.add(0, this);
        if (this.parent != null) {
            ((NodeAdapter)this.parent).addToPathVector(pathVector);
        }
    }

    public int getNodeLevel() {
        int level = 0;
        MindMapNode parent = this;
        while (!parent.isRoot()) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }
}

