/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.CloudAdapter;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindIcon;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.NodeAdapter;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class XMLElementAdapter
extends XMLElement {
    private Object userObject = null;
    private FreeMindMain frame;
    private NodeAdapter mapChild = null;
    private String fontName;
    private int fontStyle = 0;
    private int fontSize = 0;
    private String iconName;
    protected Vector ArrowLinkAdapters;
    protected HashMap IDToTarget;

    public XMLElementAdapter(FreeMindMain frame) {
        this.frame = frame;
        this.ArrowLinkAdapters = new Vector();
        this.IDToTarget = new HashMap();
    }

    protected XMLElementAdapter(FreeMindMain frame, Vector ArrowLinkAdapters, HashMap IDToTarget) {
        this.frame = frame;
        this.ArrowLinkAdapters = ArrowLinkAdapters;
        this.IDToTarget = IDToTarget;
    }

    protected abstract XMLElement createAnotherElement();

    protected abstract NodeAdapter createNodeAdapter(FreeMindMain var1);

    protected abstract EdgeAdapter createEdgeAdapter(NodeAdapter var1, FreeMindMain var2);

    protected abstract CloudAdapter createCloudAdapter(NodeAdapter var1, FreeMindMain var2);

    protected abstract ArrowLinkAdapter createArrowLinkAdapter(NodeAdapter var1, NodeAdapter var2, FreeMindMain var3);

    protected FreeMindMain getFrame() {
        return this.frame;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public NodeAdapter getMapChild() {
        return this.mapChild;
    }

    public void setName(String name) {
        super.setName(name);
        if (name.equals("node")) {
            this.userObject = this.createNodeAdapter(this.frame);
        }
        if (name.equals("edge")) {
            this.userObject = this.createEdgeAdapter(null, this.frame);
        }
        if (name.equals("cloud")) {
            this.userObject = this.createCloudAdapter(null, this.frame);
        }
        if (name.equals("arrowlink")) {
            this.userObject = this.createArrowLinkAdapter(null, null, this.frame);
        }
    }

    public void addChild(XMLElement child) {
        if (this.getName().equals("map")) {
            this.mapChild = (NodeAdapter)child.getUserObject();
            return;
        }
        if (this.userObject instanceof NodeAdapter) {
            NodeAdapter node = (NodeAdapter)this.userObject;
            if (child.getUserObject() instanceof NodeAdapter) {
                node.insert((NodeAdapter)child.getUserObject(), -1);
            } else if (child.getUserObject() instanceof EdgeAdapter) {
                EdgeAdapter edge = (EdgeAdapter)child.getUserObject();
                edge.setTarget(node);
                node.setEdge(edge);
            } else if (child.getUserObject() instanceof CloudAdapter) {
                CloudAdapter cloud = (CloudAdapter)child.getUserObject();
                cloud.setTarget(node);
                node.setCloud(cloud);
            } else if (child.getUserObject() instanceof ArrowLinkAdapter) {
                ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)child.getUserObject();
                arrowLink.setSource(node);
                this.ArrowLinkAdapters.add(arrowLink);
            } else if (child.getName().equals("font")) {
                node.setFont((Font)child.getUserObject());
            } else if (child.getName().equals("icon")) {
                node.addIcon((MindIcon)child.getUserObject());
            }
        }
    }

    public void setAttribute(String name, Object value) {
        String sValue = value.toString();
        if (this.ignoreCase) {
            name = name.toUpperCase();
        }
        if (this.userObject instanceof NodeAdapter) {
            NodeAdapter node = (NodeAdapter)this.userObject;
            if (name.equals("TEXT")) {
                node.setUserObject(sValue);
            } else if (name.equals("FOLDED")) {
                if (sValue.equals("true")) {
                    node.setFolded(true);
                }
            } else if (name.equals("POSITION")) {
                node.setLeft(sValue.equals("left"));
            } else if (name.equals("COLOR")) {
                if (sValue.length() == 7) {
                    node.setColor(Tools.xmlToColor(sValue));
                }
            } else if (name.equals("LINK")) {
                node.setLink(sValue);
            } else if (name.equals("STYLE")) {
                node.setStyle(sValue);
            } else if (name.equals("ID")) {
                this.IDToTarget.put(sValue, node);
            }
            return;
        }
        if (this.userObject instanceof EdgeAdapter) {
            EdgeAdapter edge = (EdgeAdapter)this.userObject;
            if (name.equals("STYLE")) {
                edge.setStyle(sValue);
            } else if (name.equals("COLOR")) {
                edge.setColor(Tools.xmlToColor(sValue));
            } else if (name.equals("WIDTH")) {
                if (sValue.equals("thin")) {
                    edge.setWidth(0);
                } else {
                    edge.setWidth(Integer.parseInt(sValue));
                }
            }
            return;
        }
        if (this.userObject instanceof CloudAdapter) {
            CloudAdapter cloud = (CloudAdapter)this.userObject;
            if (name.equals("STYLE")) {
                cloud.setStyle(sValue);
            } else if (name.equals("COLOR")) {
                cloud.setColor(Tools.xmlToColor(sValue));
            } else if (name.equals("WIDTH")) {
                cloud.setWidth(Integer.parseInt(sValue));
            }
            return;
        }
        if (this.userObject instanceof ArrowLinkAdapter) {
            ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)this.userObject;
            if (name.equals("STYLE")) {
                arrowLink.setStyle(sValue);
            } else if (name.equals("COLOR")) {
                arrowLink.setColor(Tools.xmlToColor(sValue));
            } else if (name.equals("DESTINATION")) {
                arrowLink.setDestinationLabel(sValue);
            } else if (name.equals("REFERENCETEXT")) {
                arrowLink.setReferenceText(sValue);
            } else if (name.equals("STARTINCLINATION")) {
                arrowLink.setStartInclination(Tools.xmlToPoint(sValue));
            } else if (name.equals("ENDINCLINATION")) {
                arrowLink.setEndInclination(Tools.xmlToPoint(sValue));
            } else if (name.equals("STARTARROW")) {
                arrowLink.setStartArrow(sValue);
            } else if (name.equals("ENDARROW")) {
                arrowLink.setEndArrow(sValue);
            } else if (name.equals("WIDTH")) {
                arrowLink.setWidth(Integer.parseInt(sValue));
            }
            return;
        }
        if (this.getName().equals("font")) {
            if (name.equals("SIZE")) {
                this.fontSize = Integer.parseInt(sValue);
            } else if (name.equals("NAME")) {
                this.fontName = sValue;
            } else if (sValue.equals("true")) {
                if (name.equals("BOLD")) {
                    ++this.fontStyle;
                } else if (name.equals("ITALIC")) {
                    this.fontStyle += 2;
                }
            }
        }
        if (this.getName().equals("icon") && name.equals("BUILTIN")) {
            this.iconName = sValue;
        }
    }

    protected void completeElement() {
        if (this.getName().equals("font")) {
            this.userObject = this.frame.getController().getFontThroughMap(new Font(this.fontName, this.fontStyle, this.fontSize));
        }
        if (this.getName().equals("icon")) {
            this.userObject = new MindIcon(this.iconName);
        }
    }

    public void processUnfinishedLinks(MindMapLinkRegistry registry) {
        this.setIDs(this.IDToTarget, registry);
        for (int i = 0; i < this.ArrowLinkAdapters.size(); ++i) {
            ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)this.ArrowLinkAdapters.get(i);
            String oldID = arrowLink.getDestinationLabel();
            NodeAdapter target = null;
            String newID = null;
            if (this.IDToTarget.containsKey(oldID)) {
                target = (NodeAdapter)this.IDToTarget.get(oldID);
                newID = registry.getLabel(target);
            } else if (registry.getTargetForID(oldID) != null) {
                target = (NodeAdapter)registry.getTargetForID(oldID);
                if (target == null) {
                    System.err.println("Cannot find the label " + oldID + " in the map. The link " + arrowLink + " is not restored.");
                    continue;
                }
                newID = registry.getLabel(target);
                if (!newID.equals(oldID)) {
                    System.err.println("Servere internal error. Looked for id " + oldID + " but found " + newID + " in the node " + target + ".");
                    continue;
                }
            } else {
                System.err.println("Cannot find the label " + oldID + " in the map. The link " + arrowLink + " is not restored.");
                continue;
            }
            arrowLink.setDestinationLabel(newID);
            arrowLink.setTarget(target);
            registry.registerLink(arrowLink);
        }
    }

    private void setIDs(HashMap IDToTarget, MindMapLinkRegistry registry) {
        Iterator i = IDToTarget.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            NodeAdapter target = (NodeAdapter)IDToTarget.get(key);
            MindMapLinkRegistry.ID_Registered newState = registry.registerLinkTarget(target, key);
            String newId = newState.getID();
            Vector cuttedLinks = registry.getCuttedNode(key);
            for (int j = 0; j < cuttedLinks.size(); ++j) {
                ArrowLinkAdapter link = (ArrowLinkAdapter)cuttedLinks.get(j);
                link.setTarget(target);
                link.setDestinationLabel(newId);
                registry.registerLink(link);
            }
        }
    }
}

