/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapArrowLink;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ArrowLinkView {
    protected MindMapArrowLink arrowLinkModel;
    protected NodeView source;
    protected NodeView target;
    protected int iterativeLevel;
    protected CubicCurve2D arrowLinkCurve;
    static final Stroke DEF_STROKE = new BasicStroke(1.0f);
    private final int MAXIMAL_RECTANGLE_SIZE_FOR_COLLISION_DETECTION = 16;

    protected ArrowLinkView(MindMapArrowLink arrowLinkModel, NodeView source, NodeView target) {
        this.arrowLinkModel = arrowLinkModel;
        this.source = source;
        this.target = target;
    }

    public Rectangle getBounds() {
        if (this.arrowLinkCurve == null) {
            return new Rectangle();
        }
        return this.arrowLinkCurve.getBounds();
    }

    public void paint(Graphics graphics) {
        boolean targetIsLeft;
        Point p2;
        boolean sourceIsLeft;
        Point p1;
        Graphics2D g = (Graphics2D)graphics.create();
        this.setRendering(g);
        g.setColor(this.getColor());
        g.setStroke(this.getStroke());
        if (this.source == null || this.target == null) {
            g.setStroke(new BasicStroke(this.getWidth(), 1, 1, 0.0f, new float[]{0.0f, 3.0f, 0.0f, 3.0f}, 0.0f));
        }
        if (this.source == null) {
            p1 = new Point(this.target.getLinkPoint());
            p1.translate(100, 0);
            sourceIsLeft = true;
        } else {
            p1 = this.source.getLinkPoint();
            sourceIsLeft = this.source.isLeft();
        }
        if (this.target == null) {
            p2 = new Point(p1);
            p2.translate(100, 0);
            targetIsLeft = true;
        } else {
            p2 = this.target.getLinkPoint();
            targetIsLeft = this.target.isLeft();
        }
        double delx = p2.x - p1.x;
        double dely = p2.y - p1.y;
        double dellength = Math.sqrt(delx * delx + dely * dely);
        int deltax = (int)(this.getZoom() * dellength);
        Point p3 = new Point(p1);
        if (this.arrowLinkModel.getStartInclination() != null) {
            p3.translate(this.arrowLinkModel.getStartInclination().x, this.arrowLinkModel.getStartInclination().y);
        } else {
            p3.translate((sourceIsLeft ? -1 : 1) * deltax, 0);
        }
        Point p4 = new Point(p2);
        if (this.arrowLinkModel.getEndInclination() != null) {
            p4.translate(this.arrowLinkModel.getEndInclination().x, this.arrowLinkModel.getEndInclination().y);
        } else {
            p4.translate((targetIsLeft ? -1 : 1) * deltax, 0);
        }
        if (this.source == null) {
            p1 = p4;
            p3 = p2;
        }
        if (this.target == null) {
            p2 = p3;
            p4 = p1;
        }
        this.arrowLinkCurve = new CubicCurve2D.Double();
        this.arrowLinkCurve.setCurve(p1, p3, p4, p2);
        g.draw(this.arrowLinkCurve);
        if (this.source != null && !this.arrowLinkModel.getStartArrow().equals("None")) {
            this.paintArrow(p1, p3, g);
        }
        if (this.target != null && !this.arrowLinkModel.getEndArrow().equals("None")) {
            this.paintArrow(p2, p4, g);
        }
    }

    private void paintArrow(Point p1, Point p3, Graphics2D g) {
        double dx = p3.x - p1.x;
        double dy = p3.y - p1.y;
        double length = Math.sqrt(dx * dx + dy * dy) / (this.getZoom() * 10.0);
        double dxn = dx / length;
        double dyn = dy / length;
        double width = 0.5;
        Polygon p = new Polygon();
        p.addPoint(p1.x, p1.y);
        p.addPoint((int)((double)p1.x + dxn + width * dyn), (int)((double)p1.y + dyn - width * dxn));
        p.addPoint((int)((double)p1.x + dxn - width * dyn), (int)((double)p1.y + dyn + width * dxn));
        p.addPoint(p1.x, p1.y);
        g.fillPolygon(p);
    }

    public boolean detectCollision(Point p) {
        if (this.arrowLinkCurve == null) {
            return false;
        }
        Rectangle2D rec = this.getControlPoint(p);
        FlatteningPathIterator pi = new FlatteningPathIterator(this.arrowLinkCurve.getPathIterator(null), 4.0, 10);
        double oldCoordinateX = 0.0;
        double oldCoordinateY = 0.0;
        while (!pi.isDone()) {
            double[] coordinates = new double[6];
            int type = pi.currentSegment(coordinates);
            switch (type) {
                case 1: {
                    if (rec.intersectsLine(oldCoordinateX, oldCoordinateY, coordinates[0], coordinates[1])) {
                        return true;
                    }
                }
                case 0: {
                    oldCoordinateX = coordinates[0];
                    oldCoordinateY = coordinates[1];
                    break;
                }
            }
            pi.next();
        }
        return false;
    }

    protected Rectangle2D getControlPoint(Point2D p) {
        int side = 16;
        return new Rectangle2D.Double(p.getX() - (double)(side / 2), p.getY() - (double)(side / 2), side, side);
    }

    public Color getColor() {
        return this.getModel().getColor();
    }

    public Stroke getStroke() {
        Stroke result = this.getModel().getStroke();
        if (result == null) {
            return DEF_STROKE;
        }
        return result;
    }

    public int getWidth() {
        return this.getModel().getWidth();
    }

    public int getRealWidth() {
        int width = this.getWidth();
        return width < 1 ? 1 : width;
    }

    protected MapView getMap() {
        return this.source == null ? this.target.getMap() : this.source.getMap();
    }

    public MindMapArrowLink getModel() {
        return this.arrowLinkModel;
    }

    protected double getZoom() {
        return this.getMap().getZoom();
    }

    protected void setRendering(Graphics2D g) {
        if (this.getMap().getController().getAntialiasEdges() || this.getMap().getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }
}

