/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Graphics2D;

public class LinearEdgeView
extends EdgeView {
    public LinearEdgeView(NodeView source, NodeView target) {
        super(source, target);
        this.update();
    }

    public void update() {
        super.update();
    }

    public void paint(Graphics2D g) {
        this.update();
        g.setColor(this.getColor());
        g.setStroke(this.getStroke());
        this.setRendering(g);
        int w = this.getWidth();
        if (w <= 1) {
            g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
        } else {
            int dx = w / 3 + 1;
            if (this.target.isLeft()) {
                dx = -dx;
            }
            int dy1 = this.getSourceShift();
            int dy2 = this.getTargetShift();
            int[] xs = new int[]{this.start.x, this.start.x + dx, this.end.x - dx, this.end.x};
            int[] ys = new int[]{this.start.y + dy1, this.start.y + dy1, this.end.y + dy2, this.end.y + dy2};
            g.drawPolyline(xs, ys, 4);
        }
        super.paint(g);
    }

    public Color getColor() {
        return this.getModel().getColor();
    }
}

