<?php
/** 
 * Send the user a reminder with the md5 checksum of his or her password via email.
 * 
 * @author	{@link http://comawiki.martignier.net Costal Martignier} initial action
 * @author	{@link http://wikkawiki.org/NilsLindenberg Nils Lindenberg} rewritten
 * @author	{@link http://wikkawiki.org/DarTar Dario Taraborelli} further cleanup, error styling and improved logical structure
 * @license http://comawiki.martignier.net/LizenzenUndBedingungen
 * @email 	actions@martignier.net
 * 
 */ 

mb_language("uni");
mb_internal_encoding("UTF-8");

// *** constant section ***
if (!defined('INPUT_ERROR_STYLE')) define('INPUT_ERROR_STYLE', 'class="highlight"');
if (!defined('PW_FORGOTTEN_HEADING')) define('PW_FORGOTTEN_HEADING', '==== 一時的なパスワード ==== ');
if (!defined('PW_CHK_SENT')) define('PW_CHK_SENT', "一時的なパスワードを%sの登録されているメールアドレスへ送りました。"); // %s - username
if (!defined('PW_FORGOTTEN_MAIL')) define('PW_FORGOTTEN_MAIL', "こんにちは、%1\$さん。\n\n\n誰かが要求したので、%2\$sにログインする一時的なパスワードを送ります。もしも、あなたがこれを要求していないのなら、このメールは無視してください。 -- 何もする必要はありません。 -- あなたのパスワードは従来のままです。\n\nあなたのwikiname: %1\$s \n一時的なパスワード: %3\$s \nURL: %4\$s \n\nログイン後、すぐにパスワードを変更することを忘れないでください。"); // %1\$ - username; %2\$s - wiki name; %3\$s - md5 sum of pw; %4\$s - login url of the wiki  
if (!defined('PW_FORGOTTEN_MAIL_REF')) define('PW_FORGOTTEN_MAIL_REF', '%sさんの一時的なパスワード'); // %s - wiki name
if (!defined('PW_FORM_TEXT')) define('PW_FORM_TEXT', 'あなたのWikiNameを入力してください。一時的なパスワードは登録されているメールアドレスへ送られます。');
if (!defined('ERROR_EMPTY_USER')) define('ERROR_EMPTY_USER', 'あなたのユーザー名を記入してください。');
if (!defined('ERROR_UNKNOWN_USER')) define('ERROR_UNKNOWN_USER', '存在しないユーザです。');
if (!defined('ERROR_MAIL_NOT_SENT')) define('ERROR_MAIL_NOT_SENT', 'パスワードの送信中にエラーが発生しました。外向きの接続が無効になっているかもしれません。お使いのサーバーの管理者に問い合わせてください。');
if (!defined('BUTTON_SEND_PW_LABEL')) define('BUTTON_SEND_PW_LABEL', '一時的なパスワードを送信');
if (!defined('USERSETTINGS_LINK')) define('USERSETTINGS_LINK', '[[UserSettings ログイン]] 画面に戻ります。');


// *** initialization ***
$input = $output = '';
$highlight = '';
$user = FALSE;
$mailsent = FALSE;

//print heading
$output .= $this->Format(PW_FORGOTTEN_HEADING);

if (isset($_POST['wikiname'])) // get posted values
{
	$input = $_POST['wikiname'];
	$user = $this->LoadUser($input);

	switch(TRUE)
	{
		case ($input == ''): // empty user
			$output .= '<em class="error">'.ERROR_EMPTY_USER.'</em><br />'."\n";
			$highlight = INPUT_ERROR_STYLE;
			break;
		case ($input != '' && !$user): // non-existing user
			$output .= '<em class="error">'.ERROR_UNKNOWN_USER.'</em><br />'."\n";
			$highlight = INPUT_ERROR_STYLE;
			break;
		case ($input != '' && $user): // user exists, proceed
			$header = "From: ".$this->config['wakka_name']." <".$this->config['admin_email'].">";
			$reference = sprintf(PW_FORGOTTEN_MAIL_REF, $user['name']);
			$mail = sprintf(PW_FORGOTTEN_MAIL, $user['name'], $this->config['wakka_name'], $user['password'], $this->config['base_url'].'UserSettings')."\n";
			if (mail($user['email'], $reference, $mail, $header))
			{
				$mailsent = TRUE;
				$output .= '<br /><em class="success">'.sprintf(PW_CHK_SENT, $user['name']).'</em><br />'."\n";
				$output .= $this->Format(USERSETTINGS_LINK);
			}
			else 
			{
				$output .= '<em class="error">'.ERROR_MAIL_NOT_SENT.'</em><br />'."\n";
			}
			break;
	}
}

// display input form
if (!$mailsent)
{
	$output .= '<p>'.PW_FORM_TEXT.'</p>'; 
//	$output .= '<form name="getwikiname" action="'.$this->href().'" method="post">';
	$output .= $this->FormOpen();
	$output .= '<input '.$highlight.' type="text" name="wikiname" value="" />';
	$output .= '<input type="submit" value="'.BUTTON_SEND_PW_LABEL.'" />';
	$output .= $this->FormClose();   
}

// *** output section ***
if ($output !== '') echo $output;
?>