#include <stdio.h>
#include <stdlib.h>
#include "js.h"
#ifdef ENABLE_GUI
extern void functionLoader_Gui(JSGlobalContextRef ctx, JSObjectRef jobjGlobal);
#endif

/*+++++++++++宣言部ここまで+++++++++++++*/

//-----関数登録機構-----

void functionLoader(JSGlobalContextRef ctx, JSObjectRef jobjGlobal)
{	
	JSObjectRef Console;
	classWrapper(ctx, jobjGlobal, "Console", &Console);
//	functionWrapper(ctx, Console, "Write", (JSObjectCallAsFunctionCallback)jsGlobalPrint);
	functionWrapper(ctx, Console, "Read", (JSObjectCallAsFunctionCallback)jsGlobalScan);
#ifdef ENABLE_GUI
    functionLoader_Gui(ctx, jobjGlobal);//(xaw.cを参照のこと。)
#endif
	functionWrapper(ctx, jobjGlobal, "print", (JSObjectCallAsFunctionCallback)jsGlobalPrint);
	functionWrapper(ctx, jobjGlobal, "fopen", (JSObjectCallAsFunctionCallback)jsGlobalF_Open);
	functionWrapper(ctx, jobjGlobal, "exec", (JSObjectCallAsFunctionCallback)jsGlobalExec);
	functionWrapper(ctx, jobjGlobal, "call", (JSObjectCallAsFunctionCallback)jsGlobalCaller);
	functionWrapper(ctx, jobjGlobal, "exit", (JSObjectCallAsFunctionCallback)jsGlobalExit);
	functionWrapper(ctx, jobjGlobal, "test", (JSObjectCallAsFunctionCallback)jsGlobalTest);

}

//-------------------


static JSValueRef jsGlobalCaller(
			 JSContextRef        ctx,
			 JSObjectRef         jobj,
			 JSObjectRef         jobjThis,
			 size_t              argLen,
			 const JSObjectRef   args[],
			 JSValueRef*         jobjExp) {


	if (argLen) {
        // 第一引数を JS の文字列としてコピー
        JSStringRef     jstrArg = JSValueToStringCopy(ctx, args[0], jobjExp);
        // 長さを取得
        size_t          len     = JSStringGetMaximumUTF8CStringSize(jstrArg);
        // 領域の確保
        char*           szArg   =  (char*)malloc(len);
        
        JSStringGetUTF8CString(jstrArg, szArg, len);

		callJsFunction(ctx, szArg);
		
        JSStringRelease(jstrArg);
        // 解放
        free(szArg);
    }
	
    // undefined を作って返す
    return JSValueMakeUndefined(ctx);
}

void callJsFunction(JSContextRef ctx, const char* func)
{
	JSStringRef jstrSource = JSStringCreateWithUTF8CString(func);
	JSEvaluateScript(ctx, jstrSource, NULL, NULL, 1, NULL); 
}

char* execCmd(const char* cmd)
{
    char* buffer;
    
    size_t buffer_size = 0;
    size_t buffer_capacity = 1024;
    buffer = (char*)malloc(buffer_capacity);
    
    FILE* f = popen(cmd, "r");
    if (!f) {
        fprintf(stderr, "Err: %s\n", cmd);
        return 0;
    }
    
    while (!feof(f) && !ferror(f)) {
        buffer_size += fread(buffer + buffer_size, 1, buffer_capacity - buffer_size, f);
        if (buffer_size == buffer_capacity) { // guarantees space for trailing '\0'
            buffer_capacity *= 2;
            buffer = (char*)realloc(buffer, buffer_capacity);
        }
    }
    pclose(f);
    buffer[buffer_size] = '\0';
    
    return buffer;
}

char* loadFile(const char* fileName)
{
    char* buffer;
    
    size_t buffer_size = 0;
    size_t buffer_capacity = 1024;
    buffer = (char*)malloc(buffer_capacity);
    
    FILE* f = fopen(fileName, "r");
    if (!f) {
        fprintf(stderr, "Could not open file: %s\n", fileName);
        return 0;
    }
    
    while (!feof(f) && !ferror(f)) {
        buffer_size += fread(buffer + buffer_size, 1, buffer_capacity - buffer_size, f);
        if (buffer_size == buffer_capacity) { // guarantees space for trailing '\0'
            buffer_capacity *= 2;
            buffer = (char*)realloc(buffer, buffer_capacity);
        }
    }
    fclose(f);
    buffer[buffer_size] = '\0';
    
    return buffer;
}
/////////////////////TEST/////////////////////////
static JSValueRef jsGlobalTest(
							   JSContextRef        ctx,
							   JSObjectRef         jobj,
							   JSObjectRef         jobjThis,
							   size_t              argLen,
							   const JSObjectRef   args[],
							   JSValueRef*         jobjExp)
{
    //dialogtest(g_argc, g_argv);
    return JSValueMakeUndefined(ctx);
}

//////////////////////////////////////////////////

static JSValueRef jsGlobalScan(
							   JSContextRef        ctx,
							   JSObjectRef         jobj,
							   JSObjectRef         jobjThis,
							   size_t              argLen,
							   const JSObjectRef   args[],
							   JSValueRef*         jobjExp) 
{
	//puts("avoid unknow error");
    char*  str =  (char*)malloc(sizeof(char[256]));
    scanf("%s",str);
    JSStringRef mystring = JSStringCreateWithUTF8CString(str);
    JSValueRef result = JSValueMakeString(ctx, mystring);
    JSStringRelease(mystring);
	free(str);
	
    return result;
}

static JSValueRef jsGlobalF_Open(
								JSContextRef        ctx,
								JSObjectRef         jobj,
								JSObjectRef         jobjThis,
								size_t              argLen,
								const JSObjectRef   args[],
								JSValueRef*         jobjExp) {

    if (argLen) {
        // 第一引数を JS の文字列としてコピー
        JSStringRef     jstrArg = JSValueToStringCopy(ctx, args[0], jobjExp);
        // 長さを取得
        size_t          len     = JSStringGetMaximumUTF8CStringSize(jstrArg);
        // 領域の確保
        char*           szArg   =  (char*)malloc(len);
        // 領域に UTF8 をコピー
        JSStringGetUTF8CString(jstrArg, szArg, len);
        // ファイル読み込み
        JSStringRef mystring = JSStringCreateWithUTF8CString(loadFile(szArg));
        JSValueRef result = JSValueMakeString(ctx, mystring);
        //全て解放
        free(szArg);
        JSStringRelease(jstrArg);
        JSStringRelease(mystring);

        return result;
    }

    // undefined を作って返す
    return JSValueMakeUndefined(ctx);
}

static JSValueRef jsGlobalExec(
								 JSContextRef        ctx,
								 JSObjectRef         jobj,
								 JSObjectRef         jobjThis,
								 size_t              argLen,
								 const JSObjectRef   args[],
								 JSValueRef*         jobjExp) {
	
    if (argLen) {
        // 第一引数を JS の文字列としてコピー
        JSStringRef     jstrArg = JSValueToStringCopy(ctx, args[0], jobjExp);
        // 長さを取得
        size_t          len     = JSStringGetMaximumUTF8CStringSize(jstrArg);
        // 領域の確保
        char*           szArg   =  (char*)malloc(len);
        // 領域に UTF8 をコピー
        JSStringGetUTF8CString(jstrArg, szArg, len);
        // コマンド実行、結果読み取り
        JSStringRef mystring = JSStringCreateWithUTF8CString(execCmd(szArg));
        JSValueRef result = JSValueMakeString(ctx, mystring);
        //全て解放
        free(szArg);
        JSStringRelease(jstrArg);
        JSStringRelease(mystring);
		
        return result;
    }
	
    // undefined を作って返す
    return JSValueMakeUndefined(ctx);
}


static JSValueRef jsGlobalPrint(
								JSContextRef        ctx,
								JSObjectRef         jobj,
								JSObjectRef         jobjThis,
								size_t              argLen,
								const JSObjectRef   args[],
								JSValueRef*         jobjExp) {
	
    if (argLen) {
        // 第一引数を JS の文字列としてコピー
        JSStringRef     jstrArg = JSValueToStringCopy(ctx, args[0], jobjExp);
        // 長さを取得
        size_t          len     = JSStringGetMaximumUTF8CStringSize(jstrArg);
        // 領域の確保
        char*           szArg   =  (char*)malloc(len);
        // 領域に UTF8 をコピー
        JSStringGetUTF8CString(jstrArg, szArg, len);
        // 出力
        puts(szArg);
        // 文字列のリファレンスカウンタをデクリメント
        JSStringRelease(jstrArg);
        // 解放
        free(szArg);
    }
	
    // undefined を作って返す
    return JSValueMakeUndefined(ctx);
}


static JSValueRef makeException(JSGlobalContextRef ctx, char* ename)
{
	if (ename) {
	JSStringRef jstrEx = JSStringCreateWithUTF8CString(ename);
	
	JSValueRef argumentsErrorValues[] = { JSValueMakeString(ctx, jstrEx) };
	
	JSObjectRef e = JSObjectMakeError(ctx, 1, argumentsErrorValues, NULL);
	printf("Error: %s",ename);
	
	JSStringRelease(jstrEx);
		return e;
	}
	
	return JSValueMakeUndefined(ctx);
}

static JSValueRef jsGlobalExit(
								 JSContextRef        ctx,
								 JSObjectRef         jobj,
								 JSObjectRef         jobjThis,
								 size_t              argLen,
								 const JSObjectRef   args[],
								 JSValueRef*         jobjExp) {
	
	exit(0);
    // undefined を作って返す
    return JSValueMakeUndefined(ctx);
}
