/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.filters;

import jp.sourceforge.logviewer.filters.FilterAction;
import jp.sourceforge.logviewer.filters.FilterResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.widgets.Shell;

public class PopupFilterAction
implements FilterAction {
    private boolean enabled;
    private final Shell shell;

    public PopupFilterAction(Shell shell) {
        this.shell = shell;
        this.enabled = true;
    }

    public void doAction(LineStyleEvent event, FilterResult result) {
        if (result.isResult()) {
            int start = result.getStart();
            int end = result.getEnd();
            String keyword = result.getInput().substring(start, end);
            StringBuilder builder = new StringBuilder();
            builder.append("column:").append(start + 1);
            builder.append(System.getProperty("line.separator"));
            builder.append("found ").append(keyword);
            MessageDialog.openInformation((Shell)this.shell, (String)"PopupFilterAction", (String)builder.toString());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

