/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.logviewer.filters.Filter;
import jp.sourceforge.logviewer.filters.FilterAction;
import jp.sourceforge.logviewer.filters.TextStyleFilterAction;
import jp.sourceforge.logviewer.util.Util;
import jp.sourceforge.logviewer.views.LogViewerEntry;
import jp.sourceforge.logviewer.views.LogViewerEntryConfig;
import jp.sourceforge.logviewer.views.LogViewerView;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static List<LogViewerEntry> createEntryList(InputStream in, LogViewerView view) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<LogViewerEntry> entryList = new ArrayList<LogViewerEntry>();
        SAXParserFactory spfactory = SAXParserFactory.newInstance();
        SAXParser parser = spfactory.newSAXParser();
        LogViewerEntryHandler handler = new LogViewerEntryHandler(view, entryList);
        parser.parse(in, (DefaultHandler)handler);
        return entryList;
    }

    public static void saveEntryList(List<LogViewerEntry> entryList, OutputStream out) throws TransformerConfigurationException, SAXException, IOException {
        TransformerFactory tf = TransformerFactory.newInstance();
        SAXTransformerFactory saxTf = (SAXTransformerFactory)tf;
        saxTf.setAttribute("indent-number", 4);
        TransformerHandler saxHandler = saxTf.newTransformerHandler();
        Transformer trans = saxHandler.getTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("method", "xml");
        trans.setOutputProperty("encoding", "UTF-8");
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        saxHandler.setResult(new StreamResult(w));
        saxHandler.startDocument();
        saxHandler.startElement("", "", "logViewerEntryList", null);
        if (entryList != null) {
            for (LogViewerEntry entry : entryList) {
                XmlUtil.saveEntry(entry, saxHandler);
            }
        }
        saxHandler.endElement("", "", "logViewerEntryList");
        saxHandler.endDocument();
    }

    private static void saveEntry(LogViewerEntry entry, TransformerHandler saxHandler) throws SAXException {
        String interval = String.valueOf(entry.getWatcher().getInterval() / 1000L);
        String enabled = Boolean.toString(entry.isEnabled());
        List<Filter> filterList = entry.getFilterList();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "", "enabled", "", enabled);
        attrs.addAttribute("", "", "interval", "", interval);
        String name = entry.getName();
        String encoding = entry.getEncoding();
        String originalFilePath = entry.getOriginalFilePath();
        AttributesImpl watchFileAttrs = new AttributesImpl();
        watchFileAttrs.addAttribute("", "", "name", "", name);
        watchFileAttrs.addAttribute("", "", "encoding", "", encoding);
        watchFileAttrs.addAttribute("", "", "path", "", originalFilePath);
        saxHandler.startElement("", "", "logViewerEntry", attrs);
        saxHandler.startElement("", "", "filterList", null);
        saxHandler.startElement("", "", "watchFile", watchFileAttrs);
        saxHandler.endElement("", "", "watchFile");
        for (Filter filter : filterList) {
            XmlUtil.saveFilter(filter, saxHandler);
        }
        saxHandler.endElement("", "", "filterList");
        saxHandler.endElement("", "", "logViewerEntry");
    }

    private static void saveFilter(Filter filter, TransformerHandler saxHandler) throws SAXException {
        String enabled = Boolean.toString(filter.isEnabled());
        String name = filter.getName();
        String pattern = filter.getPatternString();
        List<FilterAction> filterActionList = filter.getFilterActionList();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "", "enabled", "", enabled);
        attrs.addAttribute("", "", "name", "", name);
        attrs.addAttribute("", "", "pattern", "", pattern);
        saxHandler.startElement("", "", "filter", attrs);
        saxHandler.startElement("", "", "filterActionList", null);
        for (FilterAction filterAction : filterActionList) {
            if (!(filterAction instanceof TextStyleFilterAction)) continue;
            XmlUtil.saveTextStyleFilterAction((TextStyleFilterAction)filterAction, saxHandler);
        }
        saxHandler.endElement("", "", "filterActionList");
        saxHandler.endElement("", "", "filter");
    }

    private static void saveTextStyleFilterAction(TextStyleFilterAction filterAction, TransformerHandler saxHandler) throws SAXException {
        String enabled = Boolean.toString(filterAction.isEnabled());
        Color foreColor = filterAction.getForeColor();
        String foreColorRed = "0";
        String foreColorGreen = "0";
        String foreColorBlue = "0";
        if (foreColor != null) {
            foreColorRed = Integer.toString(foreColor.getRed());
            foreColorGreen = Integer.toString(foreColor.getGreen());
            foreColorBlue = Integer.toString(foreColor.getBlue());
        }
        Color backColor = filterAction.getBackColor();
        String backColorRed = "255";
        String backColorGreen = "255";
        String backColorBlue = "255";
        if (backColor != null) {
            backColorRed = Integer.toString(backColor.getRed());
            backColorGreen = Integer.toString(backColor.getGreen());
            backColorBlue = Integer.toString(backColor.getBlue());
        }
        String style = Integer.toString(filterAction.getFontStyle());
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "", "enabled", "", enabled);
        AttributesImpl foreAttrs = new AttributesImpl();
        foreAttrs.addAttribute("", "", "enabled", "", "true");
        foreAttrs.addAttribute("", "", "red", "", foreColorRed);
        foreAttrs.addAttribute("", "", "green", "", foreColorGreen);
        foreAttrs.addAttribute("", "", "blue", "", foreColorBlue);
        AttributesImpl backAttrs = new AttributesImpl();
        backAttrs.addAttribute("", "", "enabled", "", "true");
        backAttrs.addAttribute("", "", "red", "", backColorRed);
        backAttrs.addAttribute("", "", "green", "", backColorGreen);
        backAttrs.addAttribute("", "", "blue", "", backColorBlue);
        AttributesImpl styleAttrs = new AttributesImpl();
        styleAttrs.addAttribute("", "", "enabled", "", "true");
        styleAttrs.addAttribute("", "", "style", "", style);
        saxHandler.startElement("", "", "textStyleFilterAction", attrs);
        saxHandler.startElement("", "", "forecolor", foreAttrs);
        saxHandler.endElement("", "", "forecolor");
        saxHandler.startElement("", "", "bgcolor", backAttrs);
        saxHandler.endElement("", "", "bgcolor");
        saxHandler.startElement("", "", "style", styleAttrs);
        saxHandler.endElement("", "", "style");
        saxHandler.endElement("", "", "textStyleFilterAction");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LogViewerEntryHandler
    extends DefaultHandler {
        private static final String LOG_VIEWER_ENTRY_LIST = "logViewerEntryList";
        private static final String LOG_VIEWER_ENTRY = "logViewerEntry";
        private static final String WATCH_FILE = "watchFile";
        private static final String FILTER_LIST = "filterList";
        private static final String FILTER = "filter";
        private static final String FILTER_ACTION_LIST = "filterActionList";
        private static final String TEXT_STYLE_FILTER_ACTION = "textStyleFilterAction";
        private static final String BGCOLOR = "bgcolor";
        private static final String FORECOLOR = "forecolor";
        private static final String STYLE = "style";
        private List<LogViewerEntry> entryList;
        private boolean entryEnabled = true;
        private int interval = 1;
        private String entryName;
        private String encoding;
        private List<Filter> filterList = new ArrayList<Filter>();
        private Filter filter;
        private File file;
        private String originalFilePath;
        private TextStyleFilterActionBuilder builder;
        private List<TextStyleFilterAction> textStyleFilterActionList = new ArrayList<TextStyleFilterAction>();
        private LogViewerView view;

        public LogViewerEntryHandler(LogViewerView view, List<LogViewerEntry> entryList) {
            this.view = view;
            this.entryList = entryList;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals(LOG_VIEWER_ENTRY_LIST)) {
                this.startLogViewerEntryList(attributes);
            } else if (name.equals(LOG_VIEWER_ENTRY)) {
                this.startLogViewerEntry(attributes);
            } else if (name.equals(WATCH_FILE)) {
                this.startWatchFile(attributes);
            } else if (name.equals(FILTER_LIST)) {
                this.startFilterList(attributes);
            } else if (name.equals(FILTER)) {
                this.startFilter(attributes);
            } else if (name.equals(FILTER_ACTION_LIST)) {
                this.startFilterActionList(attributes);
            } else if (name.equals(TEXT_STYLE_FILTER_ACTION)) {
                this.startTextStyleFilterAction(attributes);
            } else if (name.equals(BGCOLOR)) {
                this.startBgcolor(attributes);
            } else if (name.equals(FORECOLOR)) {
                this.startForecolor(attributes);
            } else if (name.equals(STYLE)) {
                this.startStyle(attributes);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (!name.equals(LOG_VIEWER_ENTRY_LIST)) {
                if (name.equals(LOG_VIEWER_ENTRY)) {
                    LogViewerEntryConfig config = new LogViewerEntryConfig(this.originalFilePath, this.file, this.entryName, this.encoding, this.interval);
                    LogViewerEntry entry = this.view.createEntry(config, this.filterList);
                    entry.setEnabled(this.entryEnabled);
                    this.entryList.add(entry);
                } else if (!name.equals(WATCH_FILE) && !name.equals(FILTER_LIST)) {
                    if (name.equals(FILTER)) {
                        for (TextStyleFilterAction action : this.textStyleFilterActionList) {
                            this.filter.addFilterAction(action);
                        }
                        this.textStyleFilterActionList.clear();
                        this.filterList.add(this.filter);
                    } else if (!name.equals(FILTER_ACTION_LIST)) {
                        if (name.equals(TEXT_STYLE_FILTER_ACTION)) {
                            this.textStyleFilterActionList.add(this.builder.build());
                        } else if (!name.equals(BGCOLOR) && !name.equals(FORECOLOR)) {
                            name.equals(STYLE);
                        }
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        private void startLogViewerEntryList(Attributes attributes) {
        }

        private void startLogViewerEntry(Attributes attributes) {
            String enabled = attributes.getValue("enabled");
            String interval = attributes.getValue("interval");
            this.entryEnabled = Boolean.valueOf(enabled);
            try {
                this.interval = Integer.parseInt(interval);
            }
            catch (NumberFormatException numberFormatException) {}
        }

        private void startWatchFile(Attributes attributes) {
            this.entryName = attributes.getValue("name");
            this.encoding = attributes.getValue("encoding");
            this.originalFilePath = attributes.getValue("path");
            String convertedPath = Util.convertDatePattern(this.originalFilePath);
            this.file = new File(convertedPath);
        }

        private void startFilterList(Attributes attributes) {
            this.filterList = new ArrayList<Filter>();
        }

        private void startFilter(Attributes attributes) {
            String enabled = attributes.getValue("enabled");
            String name = attributes.getValue("name");
            String pattern = attributes.getValue("pattern");
            this.filter = new Filter(pattern);
            this.filter.setName(name);
            this.filter.setEnabled(Boolean.valueOf(enabled));
        }

        private void startFilterActionList(Attributes attributes) {
        }

        private void startTextStyleFilterAction(Attributes attributes) {
            String enabled = attributes.getValue("enabled");
            this.builder = new TextStyleFilterActionBuilder();
            this.builder.setEnabled(enabled);
        }

        private void startBgcolor(Attributes attributes) {
            Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            String enabled = attributes.getValue("enabled");
            String red = attributes.getValue("red");
            String green = attributes.getValue("green");
            String blue = attributes.getValue("blue");
            Color bgcolor = null;
            if (enabled.equals("true")) {
                bgcolor = new Color((Device)display, Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue));
            }
            this.builder.setBgcolor(bgcolor);
        }

        private void startForecolor(Attributes attributes) {
            Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            String enabled = attributes.getValue("enabled");
            String red = attributes.getValue("red");
            String green = attributes.getValue("green");
            String blue = attributes.getValue("blue");
            Color forecolor = null;
            if (enabled.equals("true")) {
                forecolor = new Color((Device)display, Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue));
            }
            this.builder.setForecolor(forecolor);
        }

        private void startStyle(Attributes attributes) {
            String enabled = attributes.getValue("enabled");
            String style = attributes.getValue(STYLE);
            if (enabled.equals("true")) {
                int styleInt = 0;
                try {
                    styleInt = Integer.parseInt(style);
                }
                catch (NumberFormatException numberFormatException) {}
                this.builder.setStyle(styleInt);
            }
        }

        class TextStyleFilterActionBuilder {
            private String enabled;
            private Color bgcolor;
            private Color forecolor;
            private int style;

            TextStyleFilterActionBuilder() {
            }

            public void setEnabled(String enabled) {
                this.enabled = enabled;
            }

            public void setBgcolor(Color bgcolor) {
                this.bgcolor = bgcolor;
            }

            public void setForecolor(Color forecolor) {
                this.forecolor = forecolor;
            }

            public void setStyle(int style) {
                this.style = style;
            }

            public TextStyleFilterAction build() {
                TextStyleFilterAction filterAction = new TextStyleFilterAction(this.forecolor, this.bgcolor, this.style);
                filterAction.setEnabled(Boolean.valueOf(this.enabled));
                return filterAction;
            }
        }
    }
}

