/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.logviewer.watchers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.logviewer.util.Util;
import jp.sourceforge.logviewer.watchers.TextUpdateEvent;
import jp.sourceforge.logviewer.watchers.TextUpdateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileWatcher
implements Runnable {
    private final File watchFile;
    private final long interval;
    private final String encoding;
    private BufferedReader reader = null;
    private final List<TextUpdateListener> textUpdateListenerList;
    boolean continueFlag = true;

    public TextFileWatcher(File watchFile) {
        this(watchFile, 1000L, System.getProperty("file.encoding"));
    }

    public TextFileWatcher(File watchFile, long interval, String encoding) {
        if (interval <= 0L) {
            interval = 1000L;
        }
        this.watchFile = watchFile;
        this.interval = interval;
        this.encoding = encoding;
        this.textUpdateListenerList = new ArrayList<TextUpdateListener>();
    }

    @Override
    public void run() {
        block29: {
            try {
                try {
                    boolean onetimeFlag = true;
                    ArrayList<String> appendLine = new ArrayList<String>();
                    while (this.continueFlag) {
                        boolean update = false;
                        if (this.watchFile.exists()) {
                            if (this.watchFile.canRead()) {
                                if (this.reader == null) {
                                    this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.watchFile), this.encoding));
                                }
                                if (this.isTruncate()) {
                                    appendLine.add("=== truncated ===");
                                    update = true;
                                } else {
                                    onetimeFlag = true;
                                    try {
                                        String line;
                                        while ((line = this.reader.readLine()) != null) {
                                            if (line.length() <= 0) continue;
                                            appendLine.add(line);
                                            update = true;
                                        }
                                    }
                                    catch (IOException e) {
                                        Util.log(4, "readLine", e);
                                        this.continueFlag = false;
                                    }
                                }
                            } else if (onetimeFlag) {
                                appendLine.add("=== " + this.watchFile.getName() + " can not read. ===");
                                update = true;
                                onetimeFlag = false;
                            }
                        } else if (onetimeFlag) {
                            appendLine.add("=== " + this.watchFile.getName() + " is not found. ===");
                            update = true;
                            onetimeFlag = false;
                        }
                        if (update) {
                            this.notifyTextUpdate(appendLine);
                            appendLine.clear();
                        }
                        try {
                            Thread.sleep(this.interval);
                        }
                        catch (InterruptedException interruptedException) {
                            this.continueFlag = false;
                        }
                    }
                }
                catch (Exception e) {
                    Util.log(4, "TextFileWatcher#run()", e);
                    if (this.reader == null) break block29;
                    try {
                        this.reader.close();
                    }
                    catch (IOException e2) {
                        Util.log(4, "TextFileWatcher close error.", e2);
                    }
                }
            }
            finally {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException e) {
                        Util.log(4, "TextFileWatcher close error.", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextUpdate(List<String> appendLine) {
        List<TextUpdateListener> list = this.textUpdateListenerList;
        synchronized (list) {
            TextUpdateEvent event = new TextUpdateEvent(this, appendLine);
            for (TextUpdateListener l : this.textUpdateListenerList) {
                l.textUpdated(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTextUpdateListener(TextUpdateListener l) {
        List<TextUpdateListener> list = this.textUpdateListenerList;
        synchronized (list) {
            return this.textUpdateListenerList.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTextUpdateListener(TextUpdateListener l) {
        List<TextUpdateListener> list = this.textUpdateListenerList;
        synchronized (list) {
            return this.textUpdateListenerList.remove(l);
        }
    }

    private boolean isTruncate() {
        return this.watchFile.length() == 0L;
    }

    public void dispose() {
        this.continueFlag = false;
        Thread.currentThread().interrupt();
    }

    public long getInterval() {
        return this.interval;
    }

    public File getWatchFile() {
        return this.watchFile;
    }
}

