#       def_spooler.py
#
#       2004.5.5
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
from Lpy.utils.get_env import get_os_type,get_process,os_systemV
#import Lpy.utils.file_utils
from Lpy.utils.file_utils import get_command_data,sys_command

S_cups = 'cupsd'
S_lpd  = 'lpd'
S_lpsched = 'lpsched' # Solaris

L_lpr = 'lpr'
L_lp  = 'lp'

platform = get_os_type()
for key in (S_cups,S_lpd,S_lpsched):
        if get_process(key,platform):
            spool_daemon = key
            break
else:
        print "Spooler is not running."
        spool_daemon = None

if spool_daemon == S_lpsched:
        spooler = L_lp
else:
        if platform in os_systemV:
            spooler = L_lp
        else:
            spooler = L_lpr

def get_default_printer():
        data = get_command_data('lpstat -d')
        if data and data[0].startswith('system'):
            return data[0].split(":")[1].strip()
        return None

def get_printers(printer):
        data = get_command_data('lpstat -a')
        if data:
            vlist = []
            for line in data:
                val = line.split()[0]
                if val.split('@')[0] != printer:
                    vlist.append(val)
            if len(vlist) >= 1:
                return vlist
        return None

def get_lpr_queues(printer):
        if spooler == L_lpr:
            cmds = 'lpq -P %s' % printer
        else:
            cmds = 'lpq -d %s' % printer
        return get_command_data(cmds)

def rm_lpr_queue(jobID,printer = None):
        if printer == None:
            cmds = "lprm %d" % jobID
        else:
            if spooler == L_lpr:
                cmds = "lprm -P %s %d" % (printer,jobID)
            else:
                cmds = "lprm -d %s %d" % (printer,jobID)
                # cancel  jobID
        if sys_command(cmds):
            return None
        return 1

## modify an existing job :: from page_queue.py
def set_queue_list(flag,jobnum,printer):
        if spool_daemon == S_cups:
            cmds = "lp -i %s -H %s" % (jobnum,flag)
        else:
            if spooler == L_lpr:
                #  topq printer (user [@host] | host | jobnumer)*
                #  hold printer (all | user [@host] | host |  jobnumer)*
                cmds = "lpc %s %s %s" % (flag,printer, jobnum)
            else: # system V
                cmds = "lp -i %s -d %s -H %s" % (jobnum,printer,flag)

        if sys_command(cmds):
            return "Error(%s)" % cmds
        return None

