#
#       page_queue.py
#
#       2003.5.17
#       2004.5.6
#       2004.11.19
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
#
############################
import gtk

import Lpy.def_spooler
import dialog_menu

hold_list = (
    ("topq"     , _("To Top")),    # 0
    ("immediate", _("Immediate")), # 1
    ("resume"   , _("Resume")),    # 2
    ("hold"     , _("Hold")),      # 3
    ("Cancel"   , _("Cancel")),    # 4
    )

class PageQueue:
    #title = " Queue"
    titles = (_("Rank"),_("Owner"),_("Job"),_("Output Filename"),_("Size"))
    buttons = (_("Printer"),_("Remove Job"),_("Modify Job"))

    if Lpy.def_spooler.spool_daemon == Lpy.def_spooler.S_cups:
        modify_list = (hold_list[1][1],hold_list[2][1],hold_list[3][1],hold_list[4][1])
    else:
        if Lpy.def_spooler.spooler == Lpy.def_spooler.L_lpr:
            modify_list = (hold_list[0][1],hold_list[3][1],hold_list[4][1])
        else:
            modify_list = (hold_list[2][1],hold_list[3][1],hold_list[4][1])

    NO_Job = ["-","No job","-","-","-"]

    import Lpy.def_parm
    dummy = Lpy.def_parm.Dummy

    def __init__(self):
        self.queue_button = None
        self.jobID = -1
        self.job_mode = None

    def page_change_queue(self,page,page_num,val):
        if val == 1: # this page
            self.button_queue()

    def page(self):
        self.queue_printer = self.P.printer
        self.PR = self.P.get_func(self.P.T_printer)
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.S.Border)
        base_vbox.set_size_request(self.S.Hsize, self.S.Vsize)
        base_vbox.show()
        scrolled_window = gtk.ScrolledWindow()
        scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC) 
        base_vbox.pack_start(scrolled_window, gtk.TRUE, gtk.TRUE, 0)
 
    ## 2004.11.18 modified 
        self.liststore = gtk.ListStore(str, str, str, str, str)
        self.treeview = gtk.TreeView(self.liststore)

        self.tvcolumn = []
        self.cell = []
 
        for ii in range(len(self.titles)):
            self.cell.append(gtk.CellRendererText())
  
            #self.cell[ii].set_property('cell-background', 'gray')
 
            self.tvcolumn.append(gtk.TreeViewColumn(self.titles[ii]))
            self.tvcolumn[ii].pack_start(self.cell[ii], True)
            self.tvcolumn[ii].set_attributes(self.cell[ii],text=ii)

            self.treeview.append_column(self.tvcolumn[ii])

        self.tvcolumn[0].set_min_width(50)
        self.tvcolumn[1].set_min_width(70)
        self.tvcolumn[2].set_min_width(40)
        self.tvcolumn[3].set_min_width(160)
        #self.tvcolumn[4].set_min_width( 80)

        colormap = self.treeview.get_colormap()
        self.treeview.modify_text(gtk.STATE_SELECTED,colormap.alloc_color('white'))
        self.treeview.modify_base(gtk.STATE_NORMAL,colormap.alloc_color('gray'))

        scrolled_window.add(self.treeview)
        self.treeview.show()
        scrolled_window.show()

        hbox = gtk.HBox(gtk.FALSE, 0)
        base_vbox.pack_start(hbox, gtk.FALSE, gtk.TRUE, 0)
        hbox.show()

        ## button
        select_button = gtk.Button(self.buttons[0])
        rm_button     = gtk.Button(self.buttons[1])
        priority_button   = gtk.Button(self.buttons[2])
        self.queue_button = gtk.Button(_("Queue(%s)") % self.queue_printer)
        ## printers_list
        printers_list = gtk.Menu()
        for key in self.PR.get_vlist():
            item = gtk.MenuItem(key)
            item.connect("activate",self.set_select_printer, key)
            item.show()
            printers_list.append(item)
        ## Modify job
        modify_job = gtk.Menu()
        for key in self.modify_list:
            item = gtk.MenuItem(key)
            item.connect("activate",self.button_priority, key)
            item.show()
            modify_job.append(item)

        hbox.pack_start(select_button, gtk.TRUE, gtk.TRUE, 0)
        hbox.pack_start(self.queue_button,gtk.TRUE, gtk.TRUE, 0)
        hbox.pack_start(priority_button  ,gtk.TRUE, gtk.TRUE, 0)
        hbox.pack_start(rm_button        ,gtk.TRUE, gtk.TRUE, 0)

        select_button.connect_object("event", self.button_press,printers_list)
        rm_button.connect("clicked", self.button_rm)
        priority_button.connect_object("event", self.button_press, modify_job)
        self.queue_button.connect("clicked", self.button_queue)

        select_button.show()
        rm_button.show()
        priority_button.show()
        self.queue_button.show()
        self.button_queue()
        return base_vbox

    ## 
    def get_jobID(self):
        selection = self.treeview.get_selection()
        model, iter = selection.get_selected()
        if iter:
            self.jobID = self.liststore.get_value(iter,2)
            self.job_mode = self.liststore.get_value(iter,0)
        else:
            self.jobID = self.NO_Job[2]

        if self.jobID == self.NO_Job[2]:
            self.jobID = -1
            self.job_mode = None
 
        #print "get_jobID:" , self.jobID,self.job_mode

    def button_press(self, widget, event):
        if event.type == gtk.gdk.BUTTON_PRESS:
            widget.popup(None, None, None, event.button, event.time)
            return gtk.TRUE
        return gtk.FALSE

    def set_select_printer(self,item, data):
        self.NO_Job[3] = data
        self.queue_printer = self.PR.get_printer(data)
        self.button_queue()

    def button_rm(self,data):
        self.get_jobID()
 
        if self.jobID < 0:
            return None
        if dialog_menu.sure_dialog(self.buttons[1],"%s: %s" % (self.titles[2],self.jobID)):
            if Lpy.def_spooler.rm_lpr_queue(int(self.jobID),self.queue_printer):
                self.button_queue()

    def button_priority(self,item, data):
        if data == hold_list[4][1]: # cancel
            return None

        self.get_jobID()
        if self.jobID < 0: 
            return None

        if data == hold_list[3][1]: # hold
            flag = hold_list[3][0]
        else: # to top
            for ii in range(3):
                if data == hold_list[ii][1]:
                    flag = hold_list[ii][0]
                    break
            if Lpy.def_spooler.spool_daemon == Lpy.def_spooler.S_cups:
                if self.job_mode == "active":
                    return None

        msg = Lpy.def_spooler.set_queue_list(flag,self.jobID,self.queue_printer)
        if msg:
            dialog_menu.message_dialog(self.buttons[2],msg)
        else:
            self.button_queue()

    def button_queue(self):
        self.liststore.clear()

        self.jobID = -1
        self.NO_Job[3] = self.queue_printer
        if self.queue_printer == self.dummy:
            return None

        self.queue_button.set_label(_("Queue(%s)") % self.NO_Job[3])
        qlists = Lpy.def_spooler.get_lpr_queues(self.queue_printer)
        if qlists is None:
            self.NO_Job[3] = "lpq Error"
            self.liststore.append(self.NO_Job)
            return None

        if len(qlists) <= 2:
            self.liststore.append(self.NO_Job)
            return None
        count = 0
        order = 0
        for line in qlists[1:]:
            count += 1
            qq = line.split()
            if count <= 1 and qq[0] != 'Rank':
                continue
            else:
                if qq[2] == 'Job': # CUPS,Solaris
                    order = 1
                    count += 1
                    break
                elif qq[2] == 'Class': # LPRng
                    order = 2
                    count += 1
                    break

        if order == 0:
            self.liststore.append(self.NO_Job)
            return None

        for line in qlists[count:]:
            qq = line.split()
            que = qq[:5]
  
            if order == 2:
                num = qq[1].rfind('@')
                if num >= 1:
                   que[1] = qq[1][0:num]
                que[2] = qq[3]
                que[3] = qq[4]
                que[4] = qq[5]
            self.liststore.append(que)
        return None
