#
#       page_setup.py
#
#       2003.6.10
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
##########################################
import gtk,types

import gui_set
import set_snmp
import set_gs
import set_media
import set_tray
import set_style

import  Lpy.def_parm

class NameSpace:
    pass

class PageSetup:
    #title = " Setup"
    import Lpy.pjl.pjl_title
    title = Lpy.pjl.pjl_title.u_setupPrinter
    sub_title = ("SNMP","GhostScript",
        Lpy.pjl.pjl_title.u_tray,Lpy.pjl.pjl_title.u_media,Lpy.pjl.pjl_title.u_style)

    SetP = NameSpace()
    # class
    SetP.SNMP  = set_snmp.MakerSNMP()
    SetP.GS    = set_gs.SetGS()
    SetP.Tray  = set_tray.TrayOption()
    SetP.Media = set_media.MediaTypes()
    SetP.Style = set_style.AdvancedPJL()

    # menu
    SetP.pageSNMP  = None
    SetP.pageGS    = None
    SetP.pageMedia = None
    SetP.pageTray  = None
    SetP.pageStyle = None

    def __init__(self):
        self.GUI = None
        self.PJL = None
        self.B_table = None
        self.model   = None
        self.notebook = None
        self.B_lang   = None
        self.A_color  = None
        self.newLang  = None

    def set_Pdict(self):
        self.ON  = self.P.ON
        self.OFF = self.P.OFF
        self.Never = self.P.Never
        self.ON_OFF = self.P.ON_OFF

        ### get parm ##
        self.G_value = self.S.G_value
        self.G_vlist = self.S.G_vlist
        self.G_support = self.S.G_support
        self.G_title   = self.S.G_title
        self.G_selected = self.S.G_selected

        self.GUI = gui_set.Gui_Set(self.get_menu_parm,self.set_parm_callback)
        self.GUI.__dict__['S'] = self
        self.re_set()

    def set_dicts(self,obj,dicts):
        obj.__dict__['S'] = self
        for key in dicts:
            obj.__dict__[key] = dicts[key]

    def re_set(self):
        if self.GUI is None:
            return None
        dicts = {'P': self.P,'PP': self.S, 'PJL': self.PJL,'GUI': self.GUI}
        self.set_dicts(self.SetP.SNMP,dicts)
        self.set_dicts(self.SetP.GS,dicts)
        self.set_dicts(self.SetP.Tray,dicts)
        self.set_dicts(self.SetP.Media,dicts)
        self.set_dicts(self.SetP.Style,dicts)

    ###### Gui_set: parm
    def get_menu_parm(self,keyname,flag):
        if keyname == self.P.T_printer:
            base = self.P.get_func(keyname)
        else:
            if flag == self.G_value:
                return self.PJL.get_func(keyname).get_tmp()
            elif flag == self.G_selected:
                return self.PJL.get_func(keyname).get_tmp_select()
            else:
                base = self.PJL.get_func(keyname)

        if  base is None:
            return self.Never
        if flag == self.G_value:
            return base.get_value()
        elif flag == self.G_vlist:
            return base.get_vlist()
        elif flag == self.G_support:
            return base.get_support()
        elif flag == self.G_title:
            return base.get_title()
        elif flag == self.G_selected:
            return base.get_selected()
        else:
            print "page_setup:get_menu_parm:(%s) flag(%s) is not defined." % (keyname,flag)
            return None

    def page(self):
        self.printer = None
        self.set_printer(self.P.printer)
        self.set_Pdict()

        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.S.Border)
        base_vbox.set_size_request(self.S.Hsize, self.S.Vsize)
        base_vbox.show()
        Tframe = gtk.Frame(self.title)
        base_vbox.pack_start(Tframe, gtk.FALSE, gtk.FALSE, 0)
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Tframe.add(Dev_box)
        Tframe.show()

        ## Abox
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()
        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
        self.A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        self.A_table = self.GUI.create_table(3)
        Abox.pack_start(self.A_table, gtk.TRUE, gtk.FALSE, 0)
        self.S_printer = self.GUI.make_table(self.A_table,0,self.A_group,self.P.T_printer,self.callback_table)
        self.S_maker = self.GUI.make_table(self.A_table,1,self.A_group,self.PJL.P_maker,self.callback_table)
        ## printertype
        self.S_type = self.GUI.make_table(self.A_table,2,self.A_group,self.PJL.P_type,self.callback_table)
        self.A_table.show()

        ## Bbox
        self.Bbox = gtk.VBox(gtk.FALSE, 0)
        self.Bbox.show()
        Dev_box.pack_start(self.Bbox,gtk.TRUE, gtk.FALSE, 0)
        ## Lang
        self.B_lang,Tlang = self.GUI.table_set(self.PJL.P_lang,self.callback_table)
        self.Bbox.pack_start(self.B_lang, gtk.TRUE, gtk.FALSE,0)
        self.A_pjl = self.GUI.make_chkbutton(self.PJL.P_pjl, None,self.callback_table)
        self.Bbox.pack_start(self.A_pjl, gtk.TRUE, gtk.FALSE, 0)
        self.A_duplex = self.GUI.make_chkbutton(self.PJL.P_duplex,
                self.PJL.get_func(self.PJL.P_duplex).get_title2(),self.callback_table)
        self.Bbox.pack_start(self.A_duplex, gtk.TRUE, gtk.FALSE, 0)
        self.model,Tmodel = self.GUI.table_set(self.PJL.P_model,self.callback_table)
        self.Bbox.pack_end(self.model, gtk.TRUE, gtk.FALSE,0)

    ## SubMenu
        Noteframe = gtk.Frame()
        base_vbox.pack_start(Noteframe, gtk.FALSE, gtk.FALSE, 0)
        table = gtk.Table(3,self.S.Table_num,gtk.FALSE)
        Noteframe.add(table)
        Noteframe.show()
        self.notebook = gtk.Notebook()
        self.notebook.set_tab_pos(gtk.POS_TOP)
        table.attach(self.notebook, 0,self.S.Table_num,0,1)
        self.notebook.show()

        self.base_menu()

        self.notebook.set_current_page(0)

    # Buttons
        button = gtk.Button('',gtk.STOCK_REDO) #STOCK_CLEAR)
        button.connect("clicked", self.clear_setting)
        table.attach(button, 0,1,1,2)
        button.show()
        button = gtk.Button("")
        table.attach(button, 1,2,1,2)
        button.show()
        button = gtk.Button('',gtk.STOCK_PREFERENCES)
        button.connect("clicked", self.default_save)
        table.attach(button, 2,3,1,2)
        button.show()
        table.show()
        return base_vbox

    def clear_menu(self):
            if self.SetP.pageStyle:
                self.notebook.remove_page(self.notebook.page_num(self.SetP.pageStyle))
            if self.SetP.pageMedia:
                self.notebook.remove_page(self.notebook.page_num(self.SetP.pageMedia))
            if self.SetP.pageTray:
                self.notebook.remove_page(self.notebook.page_num(self.SetP.pageTray))
            if self.model:
                self.model.hide()
            self.SetP.pageMedia = None
            self.SetP.pageTray  = None
            self.SetP.pageStyle = None

    def base_menu(self):
        if self.SetP.pageGS == None:
            self.SetP.pageSNMP = self.SetP.SNMP.page()
            self.SetP.pageGS = self.SetP.GS.page()
            self.notebook.append_page(self.SetP.pageSNMP,gtk.Label(self.sub_title[0]))
            self.notebook.append_page(self.SetP.pageGS,gtk.Label(self.sub_title[1]))

        if self.PJL.get_func(self.PJL.P_pjl).get_tmp() != self.ON:
            return None

        if self.SetP.pageTray == None:
            self.SetP.pageTray  = self.SetP.Tray.page()
            self.SetP.pageMedia = self.SetP.Media.page()
            self.SetP.pageStyle = self.SetP.Style.page()
            self.notebook.append_page(self.SetP.pageTray,gtk.Label(self.sub_title[2]))
            self.notebook.append_page(self.SetP.pageMedia,gtk.Label(self.sub_title[3]))
            self.notebook.append_page(self.SetP.pageStyle,gtk.Label(self.sub_title[4]))
            self.notebook.set_current_page(0)

    def upper_menu(self):
        val = self.P.get_func(self.P.T_printer).get_selected(self.printer)
        self.S_printer.set_history(val)

        # redraw
        self.SetP.SNMP.change_tmp_value()
        self.SetP.GS.change_button()

        self.S_maker.set_history(self.PJL.get_func(self.PJL.P_maker).get_tmp_select())

        self.A_table.remove(self.S_type)
        self.S_type = self.GUI.create_option_menu(self.callback_table,self.PJL.P_type)
        self.A_group.add_widget(self.S_type)
        row = 2
        self.A_table.attach(self.S_type, 1, 2, row, row + 1, 0, 0, 0, 0)

        if self.B_lang:
            self.Bbox.remove(self.B_lang)
        self.B_lang,Tlang = self.GUI.table_set(self.PJL.P_lang,self.callback_table)
        self.Bbox.pack_start(self.B_lang, gtk.TRUE, gtk.FALSE,0)
        self.Bbox.reorder_child(self.B_lang, 0)

        if self.model:
            self.Bbox.remove(self.model)
        self.model,Tmodel = self.GUI.table_set(self.PJL.P_model,self.callback_table)
        self.Bbox.pack_end(self.model, gtk.TRUE, gtk.FALSE,0)

        ## PJL
        pjl = self.PJL.get_func(self.PJL.P_pjl).get_tmp()
        if pjl == self.Never:
            self.A_pjl.hide()
        else:
            self.A_pjl.show()
            if pjl == self.ON:
                self.A_pjl.set_active(gtk.TRUE) 
            else:
                self.A_pjl.set_active(gtk.FALSE)
        ## Duplex
        duplex = self.PJL.get_func(self.PJL.P_duplex).get_tmp()
        if duplex == self.Never:
            self.A_duplex.hide()
        else:
            self.A_duplex.show()
            if duplex == self.ON:
                self.A_duplex.set_active(gtk.TRUE)
            else:
                self.A_duplex.set_active(gtk.FALSE)
        self.notebook.queue_draw_area(0,0,-1,-1)

    def change_menu(self):
        if self.notebook is None:
            return None
        self.clear_menu()
        self.upper_menu()
        self.base_menu()

## Set parm
    def set_printertype(self,ret):
        ptype = self.PJL.get_func(self.PJL.P_type).get_tmpValue()
        if ret != ptype:
            model = self.PJL.get_func(self.PJL.P_model).get_tmpValue()
            #print "set_printertype",ret, ptype ,model
            self.PJL.change_models(ret,model)

    def set_duplex(self,ret):
        self.PJL.get_func(self.PJL.P_duplex).set_tmp(ret)
        if self.SetP.Tray:
            self.SetP.Tray.coverduplex_show(ret)

    def set_langPJL(self,ret,lang = None):
        self.PJL.get_func(self.PJL.P_pjl).set_tmp(ret)
        if lang:
            self.newLang = lang

    def set_colorPrinter(self,ret):
        if self.A_color:
            self.PJL.get_func(self.PJL.P_colorPrinter).set_tmp(ret)

    def callback_table(self,widget,keyname,data=None):
        if keyname == self.P.T_printer:
            printer = self.P.get_func(keyname).get_printer(data)
            if printer != self.printer:
                if self.set_printer(printer) != self.S.ON:
                    return None

        elif keyname == self.PJL.P_duplex:
            ret = self.ON_OFF[widget.get_active()]
            self.set_duplex(ret)
            return None
        elif keyname == self.PJL.P_pjl:
            ret = self.ON_OFF[widget.get_active()]
            self.set_langPJL(ret)
        elif keyname == self.PJL.P_lang:
            self.PJL.get_func(keyname).set_tmpValue(data)
        elif keyname == self.PJL.P_colorPrinter:
            self.PJL.get_func(keyname).set_tmpValue(data)
            return None
        else:
            maker = self.PJL.get_func(self.PJL.P_maker).get_tmpValue()
            ptype = self.PJL.get_func(self.PJL.P_type).get_tmpValue()
            model = self.PJL.get_func(self.PJL.P_model).get_tmpValue()

            if keyname == self.PJL.P_maker:
                if data == maker:
                     return None
                if self.printer == Lpy.def_parm.Dummy and maker == Lpy.def_parm.Dummy:
                    self.upper_menu()
                    return None
                self.PJL.get_func(keyname).set_tmpValue(data)
                PJL = self.P.set_maker(self.printer,data)
                if PJL:
                    self.PJL = PJL
            elif keyname == self.PJL.P_type:
                if data == ptype:
                    return None
                self.PJL.change_models(data,model)
            elif keyname == self.PJL.P_model:
                if data == model:
                    return None
                self.PJL.change_models(ptype,data)
            else:
                return None

            self.re_set()
            self.PJL.get_tmp_all()

        self.change_menu()

    def set_parm_callback(self,keyname,value,flag = None):
        if flag is None:
            self.PJL.get_func(keyname).set_tmp(value)
        else:
            print "page_setup.py set_parm_callback: Error (%s:%s)" % (keyname,flag)
            return None
        if keyname == self.PJL.P_GS:
            self.SetP.GS.change_button()

## Set
    def set_printer(self,printer):
        if printer != self.printer:
            self.printer = printer
            self.PJL = self.P.get_printer_pjl(self.printer)
            self.PJL.get_tmp_all()
            self.re_set()
            return self.S.ON
        return self.S.OFF

    def clear_setting(self,button):
        self.printer = None
        self.set_printer(self.P.printer)
        self.change_menu()

    def default_save(self, button):
        self.PJL.set_tmp_all()
        self.SetP.SNMP.set_tmp_value()

        if self.SetP.Media:
            self.SetP.Media.set_parmlists()
        if self.SetP.Tray:
            self.SetP.Tray.set_parmlists()
        if self.newLang:
            self.PJL.get_func(self.PJL.P_lang).set_vlist(self.newLang,0)

        self.P.save_pjl_file(self.PJL,self.printer)

        self.P.PJL_dict[self.printer] = self.PJL
        self.P.set_pjl_parm(self.printer,1)

        self.S.menu_change()
