#
#       set_gs.py
#
#       2004.1.5
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk

import Lpy.fconvert.file_type

class SetGS:
    import Lpy.pjl.pjl_title 
    #title = "GhostScript device(filter)"
    comment1 = Lpy.pjl.pjl_title.u_gs_comment1
    comment2 = Lpy.pjl.pjl_title.u_gs_comment2
    comment3 = Lpy.pjl.pjl_title.u_gs_comment3

    def __init__(self):
        self.gs_chk = None
        self.GS_support = None
        self.cbox = None

    def page(self):
        self.base_vbox = gtk.VBox(gtk.FALSE, 0)
        self.base_vbox.set_border_width(self.PP.Border)
        self.base_vbox.show()
        ADev_box = gtk.HBox(gtk.TRUE, 0)
        ADev_box.show()
        self.base_vbox.pack_start(ADev_box,gtk.FALSE,gtk.FALSE,0)
        self.gs_chk = self.GUI.make_chkbutton(self.PJL.P_GS)
        ADev_box.pack_start(self.gs_chk,gtk.FALSE,gtk.FALSE,0)
        self.cbox = self.check_ghostscript()
        self.base_vbox.pack_start(self.cbox,gtk.FALSE,gtk.FALSE,0)
        return self.base_vbox

    def change_button(self):
        if self.gs_chk is None or self.GS_support != self.S.ON:
            return None

        if self.PJL.get_func(self.PJL.P_GS).get_tmp() == self.S.ON:
            self.gs_chk.set_active(gtk.TRUE) 
        else:
            self.gs_chk.set_active(gtk.FALSE)

        self.base_vbox.remove(self.cbox)
        self.cbox = self.check_ghostscript()
        self.base_vbox.pack_start(self.cbox,gtk.FALSE,gtk.FALSE,0)

    def check_ghostscript(self):
        ret = self.PJL.get_func(self.PJL.P_GS).get_tmp()
        if ret == self.S.OFF or ret == self.S.Never:
            flag = 1
            label1 = gtk.Label(self.comment1)
        else:
            lang = self.PJL.get_func(self.PJL.P_lang).get_tmpValue()
            if lang == Lpy.fconvert.file_type.F_ps:
                flag = 1
                label1 = gtk.Label(self.comment2)
            else:
                flag = 0

        if flag == 1:
            cbox = gtk.VBox(gtk.FALSE,3)
            cbox.set_border_width(3)
            cbox.show()
            label1.show()
            cbox.pack_start(label1, gtk.TRUE,gtk.TRUE,0)
            return cbox

        devicelists = self.useful_device(lang)
        if devicelists == None:
            self.PJL.get_func(self.PJL.P_GS).set_support(self.S.OFF)
            self.GS_support = self.S.OFF
            cbox = gtk.VBox(gtk.FALSE,3)
            cbox.set_border_width(3)
            cbox.show()
            label = gtk.Label(self.comment3)
            label.show()
            cbox.pack_start(label, gtk.TRUE,gtk.TRUE,0)
            return cbox
        else:
            gs_device = self.PJL.get_func(self.PJL.P_GS).get_tmpValue()
            cbox = self.GUI.radioButton_list(self.PJL.P_GS,4,devicelists,gs_device,self.callback_radio)
            self.GS_support = self.S.ON

        scrolled_window = gtk.ScrolledWindow()
        lmax = len(devicelists) 
        if lmax <= 4:
            hh = 80
        elif lmax <= 12:
            hh = 110
        else:
            hh = 160
        scrolled_window.set_size_request(-1,hh)
        scrolled_window.show()
        scrolled_window.add_with_viewport(cbox)
        return scrolled_window

    def useful_device(self,lang):
        printerType = self.PJL.get_func(self.PJL.P_type).get_tmpValue()
        if printerType == None or printerType == self.P.Never:
            #print "set_gs.py: useful_device printerType:Error"
            return None

        color  = self.PJL.get_func(self.PJL.P_colorPrinter).get_tmpValue()
        model  = self.PJL.get_func(self.PJL.P_model).get_tmpValue()
        return self.PJL.get_func(self.PJL.P_GS).get_device_list(printerType,lang,color,model)

    def callback_radio(self,widget,keyname,name):
        if widget.get_active() == 1:
            self.PJL.get_func(keyname).set_tmpValue(name)

