#
#       message_win.py
#
#       2004.4.28
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import os

import Lpy.utils.file_utils
import Lpy.utils.get_env
import Lpy.fconvert.f_encoding

wait_main   = "wait_msg"
output_main = "output_msg"

output_prg = None
encoding = Lpy.fconvert.f_encoding.get_encode()

def nowait_process(flag,msg1,msg2,msg3 = None):
    if output_prg is None:
        print "Message_Win program is not found or check a file permission." 
        return 0
    if flag in (wait_main,output_main):
        return os.spawnlp(os.P_NOWAIT,output_prg,output_prg,flag,encoding,msg1,msg2,msg3)
    return 0

class Message_Win:
    map_base = "/var/tmp/.dac_map"
  
    def __init__(self,gui_menu):
        import def_parm
        import lpy_programs
        global output_prg

        self.pid = 0
        self.mapfile = None

        if gui_menu == def_parm.gui_gtk:
            self.msg_program = "gtk_msg.py"
            prg = "gtk_menu" + os.sep + self.msg_program
        elif gui_menu == def_parm.gui_qt:
            self.msg_program = None
            prg = None

        if prg:
            output_prg = lpy_programs.check_sp_program(prg)
        else:
            output_prg = None

    def start_Window(self,msg1,msg2):
        self.mapfile = "%s_%d" % (self.map_base,Lpy.utils.file_utils.get_random_number(1000,9999))
        self.pid = nowait_process(output_main,msg1,msg2,self.mapfile)

    def msg_logs(self,msg1,msg2 = None):
        if not msg1 or self.pid == 0:
            return None
        fp = open(self.mapfile,"a")
        if msg2:
            fp.write(msg1 + msg2)
        else:
            fp.write(msg1)
        fp.flush()
        fp.close()

    def get_pid(self):
        if self.msg_program is None:
            return self.pid
        pid = Lpy.utils.get_env.check_process(self.msg_program,output_main)
        if pid > 0 and pid > self.pid:
            self.pid = pid
        return self.pid

    def end_msg_win(self):
        if self.pid:
            import signal
            os.kill(self.pid,signal.SIGKILL)
        self.pid = 0
        Lpy.utils.file_utils.remove_file(self.mapfile)
