#! /usr/bin/env python
#
#       setup.py for lpy
#       V 0.8
#       2004.6.24
#       2004.11.24
#
#       Design And Communication inc
#       By H.Nakano
#
#   install)
#       python setup.py build
#       sudo python setup.py install
#
#   delete)
#       python setup.py delete
#
##################################################################
import  os,sys

from distutils import sysconfig
from distutils.core import setup

import Lpy.lpy_version

project_dir  = Lpy.lpy_version.Project_dir
command_name = Lpy.lpy_version.Command_name
install_dir  = sysconfig.get_python_lib() + os.sep + Lpy.lpy_version.Project_dir

exe_tgt = sys.prefix + os.sep + 'bin'
M_install = 'install'
M_delete  = 'uninstall'

# grog : miss Redhat 9,FedoraCore1,2
check_prg =('grog',)

#Lpy_files = [(install_dir, ['README','License'])]

Lpy_packages = [project_dir,
        "%s.gtk_menu" % project_dir,
        "%s.fconvert" % project_dir,
        "%s.pjl"      % project_dir,
        "%s.snmp"     % project_dir,
        "%s.snmp.oid" % project_dir,
        "%s.utils"    % project_dir,
        "%s.tools"    % project_dir,
        "%s.vendors"  % project_dir,
        "%s.vendors.hp_snmp" % project_dir,
        ]

classifiers = """\
Development Status :: 3 - Alpha
Intended Audience :: End Users/Desktop
License :: OSI Approved :: GNU General Public License (GPL)
Operating System :: Unix
Programming Language :: Python
Topic :: Printing
"""

if sys.version_info < (2, 3):
    _setup = setup
    def setup(**kwargs):
        if kwargs.has_key("classifiers"):
            del kwargs["classifiers"]
        _setup(**kwargs)


###########################################
def remove_file(file):
    if os.path.isfile(file):
        try :
            os.unlink(file)
            print "remove OK. (%s)" % (file)
        except :
            print "I can't delete a file (%s)." % (file)

def copy_file(file,target):
    ret = os.system("cp %s %s" % (file,target))
    if ret == 0:
        print "Install OK. (%s -> %s)" % (file,target)
    else:
        print "Install Error. (copy %s -> %s)" % (file,target)
    return ret

def copy_po_files(mode):
    if mode != M_install and mode != M_delete:
        return None

    import  glob
    locale_dir  = os.path.join(sys.prefix,'share','locale')
    target_file = command_name + '.mo'
    cdir = os.getcwd()
    os.chdir('po') 
    mo_files = glob.glob("*.mo")
    if mo_files:
        for file in mo_files:
            target = os.path.join(locale_dir,file[:-3],"LC_MESSAGES",target_file)
            if mode == M_install:
                copy_file(file,target)
            elif mode == M_delete:
                remove_file(target)
    os.chdir(cdir)

def exe_chmod(tgt):
    if not os.path.isfile(tgt):
        print "exe_chmod: %s is not found." % tgt
        return None
    if not sys.platform.startswith('mac'):
        try :
            os.chmod(tgt, 0755)
        except :
            print "Error: chmod %s " % tgt

def exe_script(src,tgt):
    if copy_file(src,tgt) != 0:
        sys.exit(1)
    exe_chmod(tgt)

def check_program(prg):
    from Lpy.utils.file_utils import find_command
    if find_command(prg) is None:
        prog = os.getcwd() + os.sep + 'subprog' + os.sep + prg
        if os.path.isfile(prog):
            exe_script(prog,exe_tgt + os.sep + prg)
            print "copy %s %s" % (prg,exe_tgt)
        else:
            print "%s is not installed." % (prg)

##############################################################

if __name__ == '__main__':
    mode = sys.argv[1]

    if mode == M_install or mode == M_delete:
        if os.getuid() != 0:
            print "\t Must be super-user."
            print "\t Please retry."
            sys.exit(1)
        
    if mode == M_delete:
        if os.path.isdir(install_dir):
            os.system("rm -rf %s" % install_dir)
            print "remove module (%s)" % (install_dir)
        remove_file(exe_tgt + os.sep + command_name)
        copy_po_files(mode)
        sys.exit(0)

    setup(
        name         = command_name,
        version      = Lpy.lpy_version.Version,
        description  = Lpy.lpy_version.Description,
        author       = Lpy.lpy_version.Author,
        author_email = Lpy.lpy_version.Email,
        url          = Lpy.lpy_version.URL,
        license      = Lpy.lpy_version.License,
        platforms    = Lpy.lpy_version.Platforms,
        long_description = Lpy.lpy_version.Long_description,
        packages     = Lpy_packages,
        classifiers  = filter(None, classifiers.split("\n")),
        )
  
    if mode == M_install:
        copy_po_files(mode)
        for name in check_prg:
            check_program(name)
        exe_script(command_name,exe_tgt + os.sep + command_name)
        exe_chmod(install_dir + os.sep + 'gtk_menu' + os.sep + 'gtk_msg.py')

