#
#       file_convert.py
#
#       2004.1.30
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.paper_size
import Lpy.utils.file_utils

import psutils
import file_type
import f_encoding


class TO_ps(psutils.PSutils):
    encode_flag = 'encoding'
    def __init__(self):
        psutils.PSutils.__init__(self)
        from  Lpy.lpy_programs import get_prg,psutil_flag
        self.C_a2ps  = get_prg('a2ps')
        self.C_image = get_prg('convert')
        self.C_dvips = get_prg('dvips')
        self.C_fixps = get_prg('fixps')
        self.C_epsffit = get_prg('epsffit')
        self.C_texi2dvi = get_prg('texi2dvi')
        #C_xpdf = get_prg('pdftops')
        self.C_groff = get_prg('groff')
        self.C_grog  = get_prg("grog")
        if self.C_grog is None:
            self.C_groff = None
        self.ps_flag = psutil_flag
  
        self.convertTypes = {   # grogram ,function, encoding(pre process), ps_utils(after process)
            file_type.F_text  : [self.C_a2ps    ,self.tops_a2ps ,self.encode_flag],
            file_type.F_binary: [self.C_a2ps    ,self.tops_binary],
            file_type.F_troff : [self.C_groff   ,self.tops_troff ,self.encode_flag,self.ps_flag],
            file_type.F_texinfo: [self.C_texi2dvi,self.tops_latex,self.encode_flag,self.ps_flag],
            file_type.F_latex : [self.C_texi2dvi,self.tops_latex,None,self.ps_flag],
            file_type.F_dvi   : [self.C_dvips   ,self.tops_dvi  ,None,self.ps_flag],
            file_type.F_ps    : [self.C_fixps   ,self.tops_ps   ,None,self.ps_flag],
            file_type.F_eps   : [self.C_epsffit ,self.tops_eps  ,None,self.ps_flag],
            file_type.F_pdf   : [self.C_gs      ,self.tops_pdf  ,None,self.ps_flag],
            file_type.F_image : [self.C_image   ,self.tops_image,None,self.ps_flag],
            }
        # self.C_a2ps_perl
        # self.tops_xpdf

    ## geneanl function ##
    def do_convert(self,ftype,parent,filedata):
        self.ftype  = ftype
        self.parent = parent
        self.filedata = filedata

        #print "do_convert:(%s,%s)" % (ftype,self.filedata.filename)

        # pre process # encoding
        if len(self.convertTypes[self.ftype]) >= 3 and self.convertTypes[self.ftype][2] == self.encode_flag:
            self.encoding()

        self.get_paperSize()
        # convert script
        cmds = self.convertTypes[self.ftype][1](self.filedata.filename)
        if cmds is None:
            return None

        ## after process # psutils ##
        if len(self.convertTypes[self.ftype]) >= 4 and self.convertTypes[self.ftype][3] == self.ps_flag:
            ps_cmds = self.psutils()
            if ps_cmds and len(ps_cmds) >= 2:
                cmds += ps_cmds

        ## create ps-file
        if cmds:
            tmpfile = Lpy.utils.file_utils.make_tmpfile("psfile")
            msg = Lpy.utils.file_utils.sys_command("%s > %s" % (cmds,tmpfile))
            if msg or Lpy.utils.file_utils.check_file(tmpfile) in Lpy.utils.file_utils.Error_lists:
                Lpy.utils.file_utils.remove_file(tmpfile)
                return None
            return tmpfile
        return None

    ## Encoding
    def encoding(self):
        out_encoding = self.parent.get_func(self.parent.T_encoding).get_encode_filter()
        if out_encoding is None:
            return None
        filenames = self.filedata.filename.strip().split()
        if self.filedata.orgfile:
            orgfiles = self.filedata.orgfile.strip().split()
        else:
            orgfiles = None

        encode_file = ''
        for vv in range(len(filenames)):
            tmp = f_encoding.file_encoding(out_encoding,filenames[vv])
            if tmp:
                encode_file += tmp + ' '
            else:
                if orgfiles:
                    msg = "Encoding Error(%s)" % (orgfiles[vv])
                else:
                    msg = "Encoding Error(%s)" % (filenames[vv])
 
                if (self.parent.get_func(self.parent.T_errorstop).get_value() == 0 or
                    self.parent.get_func(self.parent.T_output).get_value()):
                    self.parent.error_menu(msg,out_encoding)
                    return None
                else:
                    self.parent.output_err(msg,out_encoding)

        if encode_file:
            self.filedata.set_tmpfile(encode_file)

    def get_paperSize(self):
        paper,hh = self.parent.get_func(self.parent.T_paper).get_realPaper(Lpy.paper_size.U_points)
        if hh is None:
            self.paper = paper
            ww,hh = Lpy.paper_size.get_papersize(paper,Lpy.paper_size.U_points)
        else:
            ww = paper
            self.paper = None
        self.ww = ww
        self.hh = hh

## text :: a2ps
    def tops_a2ps(self,filename):
        # encode on
        return "%s %s %s" % (self.C_a2ps,self.parent.a2ps_duplex(0),filename)

## binary
    def tops_binary(self,filename):
        # encode off
        return "%s --print-anyway %s %s" % (self.C_a2ps,self.parent.a2ps_duplex(1),filename)

## troff
    def tops_troff(self,filename):
        cmds = "%s -Tps -P -p%sp,%sp %s" % (self.C_grog,self.hh,self.ww,filename)
        gscript = Lpy.utils.file_utils.get_command_data(cmds)
        if gscript:
            return gscript[0][:-1]
        else:
            self.parent.write_logs("Error:Tops_Troff (grog -Tps)(%s)" % filename)
        return None

## Latex ::texi2dvi
    def tops_latex(self,filename):
        if self.ftype == file_type.F_texinfo:
            tex_flag = "-l Texinfo -t makeinfo"
        elif self.ftype == file_type.F_latex:
            tex_flag = "-l LaTeX"
        else:
            return None
        tmpfile = Lpy.utils.file_utils.make_tmpfile("tex_file")
        cmds = "%s -b -c -q %s -o %s %s" % (self.C_texi2dvi,tex_flag,tmpfile,filename)
        msg = Lpy.utils.file_utils.sys_command(cmds)
        if msg:
            Lpy.utils.file_utils.remove_file(tmpfile)
            self.parent.write_logs("Error:tops_latex (%s)" % cmds)
            return None
        self.filedata.set_tmpfile(tmpfile)
        return self.tops_dvi(tmpfile)

## dvi ::dvips
    def tops_dvi(self,filename):
        # -O xx,yy (origin move)
        # dvips:DVI file must be not a pipe.
        cmds = "%s -f -q -T %spt,%spt %s" % (self.C_dvips,self.ww,self.hh,filename)
        return cmds

## PS ==> PS
    def tops_ps(self,filename):
        return "%s -q -o- %s" % (self.C_fixps,filename)

## EPS ==> PS
    def tops_eps(self,filename):
        if self.paper == "lettersmall" or self.paper == "a4small":
            edge = 25
        else:
            edge = 24
        boxs = '%d %d %d %d' % (edge,edge,int(self.ww) - edge,int(self.hh) - edge)
        return "%s -c -a -m -s %s %s" % (self.C_epsffit,boxs,filename)

## PDF ==> PS (gs)
    def tops_pdf(self,filename):
        papersize,hh = self.parent.get_func(self.parent.T_paper).get_realPaper(Lpy.paper_size.U_points)
        filter = self.parent.PJL.get_func(self.parent.PJL.P_GS).get_basefilter(papersize,hh)
        if filter is None:
            return None # there is not GS.
            # -dASCII85EncodePages=false , -dLanguageLevel=1|2|3
        return '%s -sDEVICE=pswrite -c save pop -f %s' % (filter,filename)

## PDF ==> PS (xpdf)
    def tops_xpdf(self,filename):
        return None
        #return '%s %s' % (self.C_xpdf,filename)

## image ==> PS
    def tops_image(self,filename):
        return "%s -page %sx%s+0+0 %s ps:- "  % (self.C_image,self.ww,self.hh,filename)

