#
#       gui_set.py
#
#       2003.6.16
#       2004.5.1
#       2004.11.17
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#########################################
import gtk
import os

##
def set_label(title):
        label = gtk.Label(title)
        label.set_alignment(0, 0.5)
        label.show()
        return label

def input_box(keyname,callback,data = None,max_input = 32):
        entry = gtk.Entry()
        entry.set_max_length(max_input)
        entry.set_visibility(gtk.TRUE)
        entry.set_property('name',keyname)
        entry.connect("event", callback,entry)
        if data:
            entry.set_text(data)
            entry.set_position(len(entry.get_text()))
        entry.show()
        return entry

def create_table(row):
        table = gtk.Table(2,row, gtk.FALSE)
        table.set_border_width(2)
        table.set_row_spacings(5)
        table.set_col_spacings(10)
        return table

def group_menu(table,group,row,menu1,menu2):
        table.attach(menu1, 0, 1, row, row + 1,gtk.EXPAND | gtk.FILL, 0, 0, 0)
        group.add_widget(menu2)
        table.attach(menu2, 1, 2, row, row + 1, 0, 0, 0, 0)


class Dac_Combo(gtk.ComboBox):
    def __init__(self,model = None):
        gtk.ComboBox.__init__(self,model)

    def set_history(self,value):
        self.set_active(value)

###
class Gui_Set:
    Vertical   = 1
    Horizontal = 2
    Upper = 3
    Side  = 4
    FLoat = 11
    Integ = 12

    def __init__(self,func_get_parm,func_callback):
        self.get_parm = func_get_parm
        self.set_callback = func_callback
        self.white = None

    def check_support(self,menu,keyname):
        if self.get_parm(keyname,self.S.G_support) != self.S.ON:
            if self.white == None:
                colormap = menu.get_colormap()
                self.white = colormap.alloc_color('white')
            menu.modify_fg(gtk.STATE_NORMAL,self.white)

    def spin_title(self,keyname,menu,label_text = None,flag = None):
        if flag and flag == self.Upper:
            SPbox = gtk.VBox(gtk.FALSE, 0)
            inter = 0
        else:
            SPbox = gtk.HBox(gtk.FALSE, 0)
            inter = 10
        SPbox.show()
        if label_text == None:
            label_text = self.get_parm(keyname,self.S.G_title)

        label = gtk.Label(label_text)
        label.show()
        SPbox.pack_start(label,gtk.TRUE,gtk.FALSE,0)
        SPbox.pack_start(menu, gtk.TRUE,gtk.TRUE,inter)
        return SPbox

    def chkbutton_spin(self,chk_menu,menu):
        SPbox = gtk.HBox(gtk.FALSE, 0)
        SPbox.show()
        SPbox.pack_start(chk_menu,gtk.FALSE,gtk.FALSE,0)
        SPbox.pack_start(menu, gtk.TRUE, gtk.TRUE,10)
        return SPbox

## radiobutton
    def callback_radio(self,widget,keyname,count):
        if widget.get_active() == 1:
            self.set_callback(keyname,count)

    def make_radiobutton(self,flag,keyname,plist = None,value = None,callback = None):
        if flag == self.Vertical:
            cbox = gtk.VBox(gtk.FALSE, 3)
        else:
            cbox = gtk.HBox(gtk.TRUE, 10)
        cbox.set_border_width(3)
        cbox.show()
        if plist is None:
            plist = self.get_parm(keyname,self.S.G_vlist)
        if not plist:
            print "make_radiobutton :(%s) list is None" % keyname
            return None
        if value is None:
            value = self.get_parm(keyname,self.S.G_value)

        if callback is None:
            callback = self.callback_radio

        count = 0
        while count < len(plist):
            if count == 0:
                button = gtk.RadioButton(None,plist[0])
            else:
                button = gtk.RadioButton(button, plist[count])
            button.connect("toggled", callback, keyname,count)
            if value == count: #plist[count]:
                button.set_active(gtk.TRUE)
            cbox.pack_start(button, gtk.FALSE, gtk.FALSE, 0)
            button.show()
            count += 1
        return cbox

    def radioButton_list(self,keyname,col,dlist,key,callback):
        cbox = gtk.VBox(gtk.FALSE,3)
        cbox.set_border_width(3)
        cbox.show()

        max = len(dlist)
        count = 0
        while count < max:
            hbox = gtk.HBox(gtk.TRUE, 0)
            hbox.show()
            cbox.pack_start(hbox, gtk.TRUE,gtk.FALSE,0)
            for i in range(col):
                num = count + i
                if num >= max:
                    break
                name = dlist[num]
                if num == 0:
                    button = gtk.RadioButton(None,name)
                else:
                    button = gtk.RadioButton(button,name)
                button.connect("toggled", callback,keyname,name)
                if key == name:
                    button.set_active(gtk.TRUE)
                hbox.pack_start(button, gtk.TRUE,gtk.TRUE, 0)
                button.show()
            count += col
        return cbox

## CheckButton
    def callback_chkbutton(self,widget,keyname):
        self.set_callback(keyname,self.S.ON_OFF[widget.get_active()])

    def make_chkbutton(self,keyname,title= None,callback = None,value=None):
        if title is None:
            title = self.get_parm(keyname,self.S.G_title)
        button = gtk.CheckButton(title)
        if callback is None:
            callback = self.callback_chkbutton
        button.connect("toggled", callback, keyname)
        if value is None:
            value = self.get_parm(keyname,self.S.G_value)
        if value == 1 or value == self.S.ON:
            button.set_active(gtk.TRUE)
        else:
            button.set_active(gtk.FALSE)
        button.show()
        return button

    def make_chkbutton2(self,keyname,title= None,callback = None,value=None):
        hbox = gtk.HBox(gtk.TRUE, 0)
        hbox.show()
        button = self.make_chkbutton(keyname,title,callback,value)
        hbox.pack_start(button, gtk.TRUE,gtk.TRUE,7)
        return  hbox

    def callback_chkbutton_dict(self,widget,slist, name):
        slist[name] = self.S.ON_OFF[widget.get_active()]

    def chkbutton_dict(self,namelist,slist,col):
        max = len(namelist)
        MVbox = gtk.VBox(gtk.TRUE,0)
        MVbox.show()
        count = 0
        while count < max:
            hbox = gtk.HBox(gtk.TRUE, 0)
            hbox.show()
            MVbox.pack_start(hbox,gtk.TRUE,gtk.FALSE,0)
            for i in range(col):
                name = namelist[count]
                button = gtk.CheckButton(name)
                button.connect("toggled", self.callback_chkbutton_dict,slist, name)
                if slist[name] == self.S.ON:
                    button.set_active(gtk.TRUE)
                button.show()
                hbox.pack_start(button, gtk.TRUE,gtk.TRUE, 6)
                count += 1
                if count >= max:
                    return MVbox
        return MVbox
## Spin Button
    def callback_spin(self,widget,keyname,flag):
        if flag == self.FLoat:
            self.set_callback(keyname,widget.get_value())
        else:
            self.set_callback(keyname,widget.get_value_as_int())

    def make_spin(self,keyname,flag = None,data = None,val = None,support = None,callback=None):
        if data is None:
            data = self.get_parm(keyname,self.S.G_vlist)
        if len(data) < 4:
            print "make_spin::%s:list error" % (keyname)
            import sys
            sys.exit(1)

        dat = data.split('-')
        if support == None:
            support = self.get_parm(keyname,self.S.G_support)
        if val == None:
            vv = self.get_parm(keyname,self.S.G_value)
            if vv:
                val = float(vv)
            else:
                val = 0.0
        if callback is None:
            callback = self.callback_spin

        if support == self.S.ON:
            adj = gtk.Adjustment(val,float(dat[0]),float(dat[1]),float(dat[2]),float(dat[3]),0.0)
        else:
            adj = gtk.Adjustment(val,val,val,0.0,0.0,0.0)

        if flag is None or flag == self.Integ:
            copies = gtk.SpinButton(adj,0,0)
        else: # Integer
            copies = gtk.SpinButton(adj,1.0,2)

        if dat[4] and int(dat[4]) > 0:
            copies.set_width_chars(int(dat[4]))
        else:
            copies.set_width_chars(4)

        if dat[5] and int(dat[5]) == 1:
            copies.set_wrap(gtk.FALSE)
        else:
            copies.set_wrap(gtk.TRUE)

        copies.set_activates_default(gtk.FALSE)
        ## for bug ??
        colormap = copies.get_colormap()
        copies.modify_base(gtk.STATE_SELECTED,colormap.alloc_color('white'))
        copies.modify_text(gtk.STATE_SELECTED,colormap.alloc_color('black'))

        copies.set_update_policy(gtk.UPDATE_IF_VALID) # UPDATE_ALWAYS)
        copies.set_numeric(gtk.TRUE)
        copies.connect("value_changed",callback,keyname,flag)
        copies.show()
        return copies

## Table
    def table_set(self,keyname,callback = None,flag = None):
        if callback is None:
            callback = self.callback_table
        if flag is None:
            flag = self.Side
        menu = self.create_option_menu(callback,keyname,
            self.get_parm(keyname,self.S.G_vlist),
            self.get_parm(keyname,self.S.G_selected))
        button = self.spin_title(keyname,menu,self.get_parm(keyname,self.S.G_title),flag)
        return button,menu

    def callback_table(self,item,keyname,data):
        self.set_callback(keyname, data)

    def create_option_menu(self,callback,keyname,slist = None,value = None):
        if slist:
            options = slist
        else:
            options = self.get_parm(keyname,self.S.G_vlist)
            if options == None:
                print "create_option_menu:(%s) value-lists is None." % keyname
                import sys
                sys.exit(1)

        if value == None:
            val = self.get_parm(keyname,self.S.G_selected)
        else:
            val = value
 
        # 2004.11.17 modified 
        if gtk.pygtk_version >= (2,4,0):
            liststore = gtk.ListStore(str) 

            if val != None:
                for op in options:
                    liststore.append([op])
            else:
                liststore.append(options[0])  

            option_menu = Dac_Combo(liststore)
        
            cell = gtk.CellRendererText()
            option_menu.pack_start(cell, gtk.TRUE)
            option_menu.add_attribute(cell,'text', 0)
            if val != None:
                option_menu.set_active(val)
                option_menu.connect("changed", self.combo_callback, (callback,keyname))
            else:
                option_menu.set_active(0)
            option_menu.show()
            return option_menu

        else:
            menu = gtk.Menu()
            if val != None:
                for op in options:
                    item = gtk.MenuItem(op)
                    item.connect("activate",callback,keyname,op)
                    item.show()
                    menu.append(item)
            else:
                item = gtk.MenuItem(options[0])
                item.show()
                menu.append(item)

            option_menu = gtk.OptionMenu()
            option_menu.set_menu(menu)
            if val != None:
                option_menu.set_history(val)
            option_menu.show()
            return option_menu

    def combo_callback(self, combobox,func_data):
        model = combobox.get_model()
        index = combobox.get_active()
        if index > -1:
            #print model[index][0], 'selected'
            callback,keyname = func_data
            callback(None,keyname, model[index][0])

    def create_table(self,row):
        return create_table(row)

    def group_table(self,table,row,group,keyname,menu,title = None,flag = 4): # Side
        if title == None:
            title = self.get_parm(keyname,self.S.G_title)

        label = gtk.Label(title)
        label.set_alignment(0, 1)

        if flag == self.Upper:
            table.attach(label, 1, 2, row, row +1,gtk.EXPAND | gtk.FILL, 0, 0, 0)
        else:
            table.attach(label, 0, 1, row, row +1, gtk.EXPAND | gtk.FILL , 0, 0, 0)
 
        label.show()
        label.set_mnemonic_widget(menu)
        group.add_widget(menu)
        if flag == self.Upper:
            table.attach(menu, 1, 2, row + 1, row + 2, 0, 0, 0, 0)
        else:
            table.attach(menu, 1, 2, row, row + 1, 0, 0, 0, 0)

    def make_table(self,table,row,group,keyname,callback=None):
        if callback is None:
            callback = self.callback_table
        menu = self.create_option_menu(callback,keyname)
        self.group_table(table,row,group,keyname,menu)
        return menu

## Key-input
    def callback_key(self, widget,event,entry):
        if event.type == gtk.gdk.KEY_RELEASE:
            self.set_callback(entry.get_property('name'),entry.get_text())
        elif event.type == gtk.gdk.FOCUS_CHANGE:
            self.set_callback(entry.get_property('name'),entry.get_text() + os.linesep)
        

    def input_hbox(self,keyname,flag = 1,label_text = None,callback = None,data = None):
        OPbox = gtk.HBox(gtk.FALSE, 0)
        OPbox.set_border_width(3)
        OPbox.show()
        if label_text is None:
            label_text = self.get_parm(keyname,self.S.G_title)
            key = None
        else:
            key = label_text

        if label_text and flag == 1:
            label = gtk.Label(label_text)
            label.set_alignment(0, 0.5)
            OPbox.pack_start(label,gtk.FALSE,gtk.FALSE,0)
            label.show()
            flag = 4 #10
        else:
            flag = 0 #5
        sdata = self.get_parm(keyname,self.S.G_vlist).split('-')
        if len(sdata) ==2:
            length = int(sdata[0])
            invisib = int(sdata[1])
        else:
            length = 256
            invisib = 0
        entry = gtk.Entry()
        entry.set_max_length(length)
        if length <= 16:
            entry.set_size_request(length*9,24)
        if invisib == 1:
            entry.set_visibility(gtk.FALSE)
        else:
            entry.set_visibility(gtk.TRUE)
        if key:
            entry.set_property('name',key)
        else:
            entry.set_property('name',keyname)
        if callback is None:
            entry.connect("event", self.callback_key,entry)
        else:
            entry.connect("event", callback,entry)
        if data is None:
            data = self.get_parm(keyname,self.S.G_value)
        if data:
            entry.set_text(data)
        entry.set_position(len(entry.get_text()))
        entry.show()
        OPbox.pack_start(entry,gtk.TRUE,gtk.TRUE,flag)
        return  OPbox,entry
