#
#       page_tray.py
#
#       2003.5.15
#       2004.7.21
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk

import Lpy.pjl.pjl_title

class PageTray:
    #title = " Tray "
    sub_title = (Lpy.pjl.pjl_title.u_intray,Lpy.pjl.pjl_title.u_outtray,
            Lpy.pjl.pjl_title.u_inputtray_exchange)
    err_Transparency = (Lpy.pjl.pjl_title.u_error_media_1,Lpy.pjl.pjl_title.u_retry)

    def __init__(self):
        self.paperSize = None
        self.fcover_table = None
        self.ohp_table = None
        self.bookLet   = None

    def page(self):
        base_vbox = gtk.VBox(gtk.FALSE, 0) # gtk.TRUE, 0)
        base_vbox.set_border_width(self.S.Border)
        base_vbox.set_size_request(self.S.Hsize, self.S.Vsize)
        base_vbox.show()

    ## Input Tray
        Tframe = gtk.Frame(self.sub_title[0])
        base_vbox.pack_start(Tframe, gtk.FALSE, gtk.FALSE, 0)
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Tframe.add(Dev_box)

        in_flag = 0
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()
        Dev_box.pack_start(Abox,gtk.TRUE, gtk.FALSE, 0)
        ## Tray: MediaSource 
        if  self.PJL.get_func(self.PJL.P_intray).get_support() == self.S.ON:
            in_button,Tintray = self.GUI.table_set(self.PJL.P_intray)
            Abox.pack_start(in_button, gtk.TRUE, gtk.FALSE,0)
            in_flag = 1

        Bbox = gtk.VBox(gtk.FALSE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox,gtk.TRUE, gtk.FALSE, 0)

        ##
        B_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        B_table = self.GUI.create_table(2)
        Bbox.pack_start(B_table,gtk.TRUE,gtk.FALSE, 0)
        count = 0
        ## Paper
        if self.PJL.get_func(self.PJL.P_mediaSize).get_support() == self.S.ON:
            self.paperSize = self.GUI.make_table(B_table,count,B_group,self.PJL.P_mediaSize,self.callback_paper)
            count += 1
            in_flag = 2
        ## MediaType
        if self.PJL.get_func(self.PJL.P_mediatype).get_support() == self.S.ON:
            self.GUI.make_table(B_table,count,B_group,self.PJL.P_mediatype,self.callback_media)
            in_flag = 2

        if in_flag == 2:
            B_table.show()

        if in_flag:
            Tframe.show()

    ## Output Tray
        Out_frame = self.output_tray()
        if Out_frame:
            base_vbox.pack_start(Out_frame,gtk.FALSE,gtk.FALSE,0)

    ## Auto Tray
        Tr_frame = self.auto_tray()
        if Tr_frame:
            base_vbox.pack_start(Tr_frame,gtk.FALSE,gtk.FALSE,0)

        return base_vbox

    def output_tray(self):
        Out_frame = gtk.Frame(self.sub_title[1])
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Out_frame.add(Dev_box)

        ## Abox
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()
        Dev_box.pack_start(Abox,gtk.TRUE, gtk.FALSE, 0)
        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = self.GUI.create_table(3)
        Abox.pack_start(A_table,gtk.TRUE,gtk.FALSE, 0)
        count = 0
        out_value = None
        outLists  = []

        if self.PJL.get_func(self.PJL.P_outtray).get_support() == self.S.ON:
            out_value = self.PJL.get_func(self.PJL.P_outtray).get_value()
            out_lists = self.PJL.get_func(self.PJL.P_outtray).get_vlist()
            for key in out_lists:
                outLists.append(key)
 
        if self.PJL.get_func(self.PJL.P_mailbin).get_support() == self.S.ON:
            mailbin_value = self.PJL.get_func(self.PJL.P_mailbin).get_value()
            if mailbin_value >=1:
                out_value = len(outLists) + mailbin_value -1

            mailbin_max = self.PJL.get_func(self.PJL.P_mailbin).get_maxval()
            for key in range(1,mailbin_max + 1):
                outLists.append(Lpy.pjl.pjl_title.u_mailbin + str(key))

        if len(outLists) >= 1:
            menu = self.GUI.create_option_menu(self.callback_outtray,self.PJL.P_outtray,outLists,out_value)
            self.GUI.group_table(A_table,count,A_group,self.PJL.P_outtray,menu)
            count += 1

        #if self.PJL.get_func(self.PJL.P_faceup).get_support() == self.S.ON:
        #    self.GUI.make_table(A_table,count,A_group,self.PJL.P_faceup)
        #    count += 1

        if self.PJL.get_func(self.PJL.P_collate).get_support() == self.S.ON:
            self.collation = self.GUI.make_spin(self.PJL.P_collate)
            self.GUI.group_table(A_table,count,A_group,self.PJL.P_collate,self.collation)  
            count += 1

        A_table.show()

        ## Bbox
        Bbox = gtk.VBox(gtk.FALSE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)

        count = 0
        if self.PJL.get_func(self.PJL.P_staple).get_support() == self.S.ON:
            B_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
            B_table = self.GUI.create_table(3)
            Bbox.pack_start(B_table,gtk.TRUE,gtk.FALSE, 0)

            self.GUI.make_table(B_table,count,B_group,self.PJL.P_staple)
            count += 1
            #if self.PJL.get_func(self.PJL.P_binding).get_support() == self.S.ON:
            self.GUI.make_table(B_table,count,B_group,self.PJL.P_binding)
            count += 1
            B_table.show()

        if self.PJL.get_func(self.PJL.P_punch).get_support() == self.S.ON:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_punch), gtk.TRUE, gtk.FALSE, 0)
        
        Out_frame.show()
        return Out_frame

    def auto_tray(self):
        self.fcover_table = None
        self.ohp_table = None
        self.bookLet   = None
        if self.PJL.get_func(self.PJL.P_mediatype).is_Transparency(): #Lpy.pjl.pjl_title.u_outtray
            ohp = self.PJL.get_func(self.PJL.P_insertPaper).get_support()
        else:
            ohp = None
        fcover  = self.PJL.get_func(self.PJL.P_coverPrint).get_support()
        booklet = self.PJL.get_func(self.PJL.P_booklet).get_support()

        if (ohp != self.S.ON and fcover != self.S.ON and booklet != self.S.ON):
            return None

        Tr_frame = gtk.Frame(self.sub_title[2])
        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Tr_frame.add(Dev_box)

        if fcover == self.S.ON or ohp == self.S.ON:
            Bbox = gtk.VBox(gtk.FALSE, 0)
            Bbox.show()
            Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
            ## FrontCover
            if fcover == self.S.ON:
                self.frontcover = self.GUI.make_chkbutton(self.PJL.P_coverPrint,None,self.callback_tray)
                Bbox.pack_start(self.frontcover,gtk.TRUE,gtk.FALSE,0)
                B_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
                self.fcover_table = self.GUI.create_table(2)
                Bbox.pack_start(self.fcover_table, gtk.FALSE,  gtk.FALSE, 0)
                self.GUI.make_table(self.fcover_table,0,B_group,self.PJL.P_coverMedia)

                if (self.PJL.get_func(self.PJL.P_coverDuplex).get_support() == self.S.ON and
                    self.PJL.get_func(self.PJL.P_duplex).get_support() == self.S.ON):
                    self.GUI.make_table(self.fcover_table,1,B_group,self.PJL.P_coverDuplex)
                elif self.PJL.get_func(self.PJL.P_coverPrinting).get_support() == self.S.ON:
                    self.GUI.make_table(self.fcover_table,1,B_group,self.PJL.P_coverPrinting)

                if self.PJL.get_func(self.PJL.P_coverPrint).get_value() == 0:
                    self.fcover_table.hide()
                else:
                    self.fcover_table.show()

            ## Transparency
            if ohp == self.S.ON:
                self.ohp_insert = self.GUI.make_chkbutton(self.PJL.P_insertPaper,None,self.callback_tray)
                Bbox.pack_start(self.ohp_insert,gtk.TRUE,gtk.FALSE, 0)
                A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
                self.ohp_table = self.GUI.create_table(2)
                Bbox.pack_start(self.ohp_table, gtk.TRUE,  gtk.FALSE, 0)
                count = 0
                if self.PJL.get_func(self.PJL.P_insertMedia).get_support() == self.S.ON:
                    self.GUI.make_table(self.ohp_table,count,A_group,self.PJL.P_insertMedia)
                    count += 1
                if self.PJL.get_func(self.PJL.P_insertPrinting).get_support() == self.S.ON:
                    self.GUI.make_table(self.ohp_table,count,A_group,self.PJL.P_insertPrinting)
                self.ohp_media()

        if booklet == self.S.ON:
            Abox = gtk.VBox(gtk.FALSE, 0)
            Abox.show()
            Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
            self.bookLet = self.GUI.make_chkbutton(self.PJL.P_booklet,None,self.callback_tray)
            Abox.pack_start(self.bookLet,gtk.TRUE,gtk.FALSE,0)

        Tr_frame.show()
        return Tr_frame

    def redraw_paperSize(self,paper = None):
        if self.PJL.get_func(self.PJL.P_mediaSize).get_support() != self.S.ON:
            return None
        if paper == None:
            paper = self.P.get_func(self.P.T_paper).get_paperName()
            if not paper:
                return None
 
        paper = paper.upper()
        plists = self.PJL.get_func(self.PJL.P_mediaSize).get_vlist()
        if paper in plists:
            self.PJL.get_func(self.PJL.P_mediaSize).set_value(paper)
            self.paperSize.set_history(plists.index(paper))  
        else: # custom
            if "CUSTOM" in plists:
                self.PJL.get_func(self.PJL.P_mediaSize).set_value("CUSTOM")
                width, height = self.P.get_func(self.P.T_paper).get_optionSize()
                self.PJL.get_func(self.PJL.P_mediaSize).set_customPaper(width,height)
            else:
                print "PaperSize(%s) is not supported by PJL_paperSize." % paper
 
    def callback_paper(self,item,keyname,data):
        self.PJL.get_func(self.PJL.P_mediaSize).set_value(data)

    def callback_media(self,item,keyname,data):
        old = self.PJL.get_func(self.PJL.P_mediatype).get_value()
        self.PJL.get_func(self.PJL.P_mediatype).set_value(data)
        if old != data:
            self.ohp_media()

    def ohp_media(self):
        if self.ohp_table:
            if (self.PJL.get_func(self.PJL.P_mediatype).is_Transparency() == self.S.ON and
                self.PJL.get_func(self.PJL.P_insertPaper).get_value() == 1):
                self.ohp_table.show()
                self.ohp_insert.set_active(gtk.TRUE)
            else:
                self.ohp_table.hide()
                self.ohp_insert.set_active(gtk.FALSE)
                self.PJL.get_func(self.PJL.P_insertPaper).set_value(0)

    def callback_outtray(self,widget,keyname,data):
        if keyname == self.PJL.P_outtray:
            if data.startswith(Lpy.pjl.pjl_title.u_mailbin):
                mailbin_max = self.PJL.get_func(self.PJL.P_mailbin).get_maxval()
                for key in range(1,mailbin_max + 1):
                    if data == Lpy.pjl.pjl_title.u_mailbin + str(key):
                        self.PJL.get_func(self.PJL.P_mailbin).set_value(key)
                        break

            else:
                out_lists = self.PJL.get_func(self.PJL.P_outtray).get_vlist()
                count = 0
                for key in out_lists:
                    if data == key:
                        self.PJL.get_func(self.PJL.P_outtray).set_value(count)
                        self.PJL.get_func(self.PJL.P_mailbin).set_value(0)
                        break
                    count += 1


    def callback_tray(self,widget,keyname):
        val = self.S.ON_OFF[widget.get_active()]

        if (keyname == self.PJL.P_insertPaper and val == self.S.ON and
            self.PJL.get_func(self.PJL.P_mediatype).is_Transparency() == self.S.OFF):
            import dialog_menu

            dialog_menu.error_dialog(self.err_Transparency[0],self.err_Transparency[1])
            self.ohp_media()
            return None

        keys = [self.PJL.P_coverPrint,self.PJL.P_insertPaper,self.PJL.P_booklet]

        if val == self.S.ON:
            for key in keys:
                if key != keyname:
                    self.PJL.get_func(key).set_value(self.S.OFF)
        self.PJL.get_func(keyname).set_value(val)

        self.ohp_media()
        if self.fcover_table:
            if self.PJL.get_func(self.PJL.P_coverPrint).get_value() == 1:
                self.fcover_table.show()
                self.frontcover.set_active(gtk.TRUE)
            else:
                self.fcover_table.hide()
                self.frontcover.set_active(gtk.FALSE)

        if self.bookLet:
            if self.PJL.get_func(self.PJL.P_booklet).get_value() == 1:
                self.bookLet.set_active(gtk.TRUE)
            else:
                self.bookLet.set_active(gtk.FALSE)

