#
#   set_tray.py
#
#   2003.6.10
#   2003.10.17
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################################
import gtk

class TrayOption:
    import Lpy.pjl.pjl_title 
    #'Tray Options'
    sub_title = (Lpy.pjl.pjl_title.u_intray, Lpy.pjl.pjl_title.u_outtray)

    def __init__(self):
        self.coverDuplex = None
        self.MailBin = None
        self.Tray = None
        self.outtray_num = None

    def page(self):
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.PP.Border)
        base_vbox.show()

        Hframe = gtk.Frame(self.sub_title[0])
        base_vbox.pack_start(Hframe, gtk.FALSE, gtk.FALSE, 0)
    # Input Tray
        ADev_box = gtk.HBox(gtk.FALSE,0)
        ADev_box.show()
        Hframe.add(ADev_box)

        ## input Tray
        Abox = self.input_tray()
        if Abox:
            ADev_box.pack_start(Abox,gtk.TRUE, gtk.FALSE, 0)

        ## Bbox
        bflag = 0
        Bbox = gtk.VBox(gtk.FALSE, 0)
        
        if self.PJL.get_func(self.PJL.P_booklet).get_tmp() != self.S.Never:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_booklet),gtk.TRUE,gtk.FALSE,0)
            bflag = 1
        if self.PJL.get_func(self.PJL.P_coverPrint).get_tmp() != self.S.Never:
            self.coverprint = self.GUI.make_chkbutton(self.PJL.P_coverPrint,None,self.callback_chkbutton)
            Bbox.pack_start(self.coverprint, gtk.TRUE,gtk.FALSE,0)
            bflag = 1
        if self.PJL.get_func(self.PJL.P_coverDuplex).get_tmp() != self.S.Never:
            self.coverDuplex = self.GUI.make_chkbutton(self.PJL.P_coverDuplex)
            Bbox.pack_start(self.coverDuplex,gtk.TRUE,gtk.FALSE,0)
            
            if (self.PJL.get_func(self.PJL.P_duplex).get_tmp() != self.S.ON or
                self.PJL.get_func(self.PJL.P_coverPrint).get_tmp() != self.S.ON):
                self.PJL.get_func(self.PJL.P_coverDuplex).set_tmp(self.S.OFF)
                self.coverDuplex.hide()
            else:
                bflag = 1

        if self.PJL.get_func(self.PJL.P_insertPaper).get_tmp() != self.S.Never:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_insertPaper),gtk.TRUE,gtk.FALSE,0)

        if bflag:
            Bbox.show()
            ADev_box.pack_start(Bbox,gtk.TRUE, gtk.FALSE, 0)

        if  Abox or bflag:
            Hframe.show()

    ## Output Tray
        Oframe = gtk.Frame(self.sub_title[1])
        base_vbox.pack_start(Oframe, gtk.FALSE, gtk.FALSE, 0)
        BDev_box = gtk.HBox(gtk.FALSE, 0) # gtk.TRUE, 0)
        BDev_box.show()
        Oframe.add(BDev_box)
        Oframe.show()

       ## Abox
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()
        BDev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)

        ## Output Tray
        if self.PJL.get_func(self.PJL.P_outtray).get_tmp() != self.S.Never:
            OutTray = self.PJL.get_func(self.PJL.P_outtray)
            stitle= OutTray.get_title2()
            plist = OutTray.get_select_list()
            self.outtray_num = OutTray.get_slist_num()
            hbox = self.GUI.make_spin(self.PJL.P_outtray,self.GUI.Integ,
                plist,self.outtray_num,self.S.ON,self.callback_intray)
            tray_label = self.GUI.spin_title(self.PJL.P_outtray,hbox,stitle)
            Abox.pack_start(tray_label,gtk.TRUE, gtk.FALSE, 4)

        ## MailBin
        if self.PJL.get_func(self.PJL.P_mailbin).get_tmp() != self.S.Never:
            mailbin_chk = self.GUI.make_chkbutton(self.PJL.P_mailbin)
            self.MailBin = self.PJL.get_func(self.PJL.P_mailbin)
            self.max_val = self.MailBin.get_maxval()
            mail_max = self.MailBin.get_select_list()
            hbox = self.GUI.make_spin(self.PJL.P_mailbin,self.GUI.Integ,
                mail_max,self.max_val,self.S.ON,self.callback_mailbin)
            mailbox = self.GUI.chkbutton_spin(mailbin_chk,hbox)
            Abox.pack_start(mailbox,gtk.TRUE, gtk.FALSE, 0)
        else:
            self.MailBin = None

        ## FaceUp
        #if self.PJL.get_func(self.PJL.P_faceup).get_tmp() != self.S.Never:
        #    Abox.pack_start(self.GUI.make_chkbutton(self.PJL.P_faceup),gtk.TRUE,gtk.FALSE, 0)

       ## Bbox
        Bbox = gtk.VBox(gtk.FALSE, 0)
        Bbox.show()
        BDev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
        if self.PJL.get_func(self.PJL.P_staple).get_tmp() != self.S.Never:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_staple) ,gtk.TRUE,gtk.FALSE,0)
        if self.PJL.get_func(self.PJL.P_punch).get_tmp() != self.S.Never:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_punch),gtk.TRUE,gtk.FALSE,0)

        if self.PJL.get_func(self.PJL.P_collate).get_tmp() != self.S.Never:
            Bbox.pack_start(self.GUI.make_chkbutton(self.PJL.P_collate) ,gtk.TRUE,gtk.FALSE,0)

        return base_vbox

    def input_tray(self):
        self.Tray = self.PJL.get_func(self.PJL.P_intray)
        if self.Tray.get_support() != self.S.ON:
            self.Tray = None
            return None

        self.tray_num    = self.Tray.get_tray_number(self.Tray.TR_tray)
        self.tray_manual = self.Tray.get_tray_support(self.Tray.TR_manual)
        self.tray_mp     = self.Tray.get_tray_support(self.Tray.TR_MPtray)
        self.tray_duplex   = self.Tray.get_tray_support(self.Tray.TR_duplex)
        self.tray_envelope = self.Tray.get_tray_support(self.Tray.TR_envelope)
        self.tray_external = self.Tray.get_tray_support(self.Tray.TR_external)
        self.tray_large    = self.Tray.get_tray_support(self.Tray.TR_large)
        self.tray_roll     = self.Tray.get_tray_support(self.Tray.TR_roll)

        Abox = gtk.VBox(gtk.FALSE, 0)
        flag = 0

        ## Tray number
        if self.tray_num >= 2:
            tray_max = self.Tray.get_select_list(self.Tray.TR_tray)
            name = self.Tray.get_tray_name(self.Tray.TR_tray)
            hbox = self.GUI.make_spin(self.Tray.TR_tray,self.GUI.Integ,
                        tray_max,self.tray_num,self.S.ON,self.callback_intray)
            tray_label = self.GUI.spin_title(self.Tray.TR_tray,hbox,name)
            Abox.pack_start(tray_label,gtk.TRUE, gtk.FALSE, 4)
            flag = 1

        ## Manual 
        if self.tray_manual and self.tray_manual != self.S.Never:
            name = self.Tray.get_tray_name(self.Tray.TR_manual)
            manual_tray = self.GUI.make_chkbutton(self.Tray.TR_manual,name,self.callback_tray,self.tray_manual)
            Abox.pack_start(manual_tray, gtk.TRUE, gtk.FALSE, 0)
            flag = 1
        ## MPtray
        if self.tray_mp and self.tray_mp != self.S.Never:
            name = self.Tray.get_tray_name(self.Tray.TR_MPtray)
            tray = self.GUI.make_chkbutton(self.Tray.TR_MPtray,name,self.callback_tray,self.tray_mp)
            Abox.pack_start(tray, gtk.TRUE, gtk.FALSE, 0)
            flag = 1

        ## TR_duplex
        if self.tray_duplex and self.tray_duplex != self.S.Never:
            name = self.Tray.get_tray_name(self.Tray.TR_duplex)
            tray = self.GUI.make_chkbutton(self.Tray.TR_duplex,name,self.callback_tray,self.tray_duplex)
            Abox.pack_start(tray, gtk.TRUE, gtk.FALSE, 0)
            flag = 1

        ## TR_envelope
        if self.tray_envelope and self.tray_envelope != self.S.Never:
            name = self.Tray.get_tray_name(self.Tray.TR_envelope)
            tray = self.GUI.make_chkbutton(self.Tray.TR_envelope,name,self.callback_tray,self.tray_envelope)
            Abox.pack_start(tray, gtk.TRUE, gtk.FALSE, 0)
            flag = 1

        ## external Tray 
        if self.tray_external and self.tray_external != self.S.Never:
            self.external_num = self.Tray.get_tray_number(self.Tray.TR_external)
            tray_max = self.Tray.get_select_list(self.Tray.TR_external)
            name  = self.Tray.get_tray_name(self.Tray.TR_external)

            external_tray = self.GUI.make_chkbutton(self.Tray.TR_external,name,self.callback_tray,self.tray_external)
            external_spin = self.GUI.make_spin(self.Tray.TR_external,self.GUI.Integ,
                    tray_max,self.external_num,self.S.ON,self.callback_intray)
            external_box = self.GUI.chkbutton_spin(external_tray,external_spin)

            Abox.pack_start(external_box,gtk.TRUE, gtk.FALSE, 4)
            flag = 1
  
        ## Large
        if self.tray_large and self.tray_large != self.S.Never:
            name_large  = self.Tray.get_tray_name(self.Tray.TR_large)
            large_tray = self.GUI.make_chkbutton(self.Tray.TR_large,name_large,self.callback_tray,self.tray_large)
            Abox.pack_start(large_tray, gtk.TRUE, gtk.FALSE, 0)
            flag = 1

        ## Roll
        if self.tray_roll and self.tray_roll != self.S.Never:
            self.roll_num = self.Tray.get_tray_number(self.Tray.TR_roll)
            name = self.Tray.get_tray_name(self.Tray.TR_roll)
            tray_max = self.Tray.get_select_list(self.Tray.TR_roll)

            roll_tray = self.GUI.make_chkbutton(self.Tray.TR_roll,name,self.callback_tray,self.tray_roll)
            rbox = self.GUI.make_spin(self.Tray.TR_roll,self.GUI.Integ,
                    tray_max,self.roll_num,self.S.ON,self.callback_intray)
            roll_box = self.GUI.chkbutton_spin(roll_tray,rbox)

            Abox.pack_start(roll_box, gtk.TRUE, gtk.FALSE, 0)
            flag = 1

        if flag:
            Abox.show()
            return Abox
        else:
            return None

    def set_input_tray(self,inTray,mpTray,Manual,Roll,FanFold):
        #print "input tray",inTray,mpTray,Manual,Roll,FanFold
        if inTray >=1:
           self.tray_num = inTray
        if Roll == 1:
            self.tray_roll = self.S.ON
 
    def set_output_tray(self,outTray,Tray,Roll,FanFold):
        #print "output tray",outTray,Tray,Roll,FanFold
        if outTray >=1:
           self.outtray_num = outTray

        if Roll >= 1:
            self.tray_roll = Roll

    def set_output_mailbin(self,flag):
        if self.PJL.get_func(self.PJL.P_mailbin).get_tmp() != self.S.Never:
            self.PJL.get_func(self.PJL.P_mailbin).set_tmp(flag)

    def set_firstToLast(self,firstToLast,lastToFirst):
        pass

    def set_faceup(self,faceUp,faceDown):
        if self.PJL.get_func(self.PJL.P_faceup).get_tmp() != self.S.Never:
            self.PJL.get_func(self.PJL.P_faceup).set_tmp(faceUp)

    def callback_intray(self,widget,keyname,flag):
        if keyname == self.Tray.TR_tray:
            self.tray_num = widget.get_value_as_int()
        elif keyname == self.Tray.TR_roll:
            self.roll_num = widget.get_value_as_int()
        elif keyname == self.Tray.TR_external:
            self.external_num = widget.get_value_as_int()

        elif keyname == self.PJL.P_outtray:
            self.outtray_num = widget.get_value_as_int()

    def callback_tray(self,widget,keyname):
        val = self.S.ON_OFF[widget.get_active()]
        if keyname == self.Tray.TR_manual :
            self.tray_manual = val
        elif keyname == self.Tray.TR_large:
            self.tray_large = val
        elif keyname == self.Tray.TR_external:
            self.tray_external = val
        elif keyname == self.Tray.TR_roll:
            self.tray_roll = val

        elif keyname == self.Tray.TR_envelope:
            self.tray_envelope = val
        elif keyname == self.Tray.TR_duplex:
            self.tray_duplex  = val

    def callback_chkbutton(self,widget,keyname):
        ret = self.S.ON_OFF[widget.get_active()]
        self.PJL.get_func(keyname).set_tmp(ret)

        related = (self.PJL.P_coverMedia,self.PJL.P_coverDuplex)
        for key in related:
            self.PJL.get_func(key).set_tmp(ret)
        self.coverduplex_show(ret)

    def coverduplex_show(self,ret):
        if self.coverDuplex is None:
            return None

        if ret == self.S.OFF:
            self.coverDuplex.set_active(gtk.FALSE)
            self.coverDuplex.hide()
        else:
            if self.PJL.get_func(self.PJL.P_duplex).get_tmp() == self.S.ON:
                self.coverDuplex.show()

    def callback_radio(self,widget,keyname,data):
        self.PJL.get_func(keyname).set_tmpValue(data)

    def callback_mailbin(self,widget,keyname,flag):
        self.max_val = widget.get_value_as_int()

    def set_parmlists(self):
        if self.MailBin and self.MailBin.get_tmp() == self.S.ON:
            self.MailBin.set_maxval(self.max_val)

        if self.Tray:
            self.Tray.set_tray_support(self.Tray.TR_manual,self.tray_manual)
            self.Tray.set_tray_support(self.Tray.TR_envelope,self.tray_envelope)
            self.Tray.set_tray_support(self.Tray.TR_duplex,self.tray_duplex)

            self.Tray.set_tray_support(self.Tray.TR_external,self.tray_external)
            self.Tray.set_tray_support(self.Tray.TR_large ,self.tray_large)
            self.Tray.set_tray_support(self.Tray.TR_roll  ,self.tray_roll)

            if self.tray_num >= 2:
                self.Tray.set_tray_number( self.Tray.TR_tray  ,self.tray_num)

            if self.tray_external == self.S.ON:
               self.Tray.set_tray_number(self.Tray.TR_external,self.external_num)

            if self.tray_roll == self.S.ON:
               self.Tray.set_tray_number(self.Tray.TR_roll,self.roll_num)

            self.Tray.set_selectDict()

        if self.outtray_num and self.PJL.get_func(self.PJL.P_outtray).get_tmp() != self.S.Never:
            self.PJL.get_func(self.PJL.P_outtray).set_vlist(self.outtray_num,0)

