#
#   pjl_vendor.py
#
#   2003.12.23
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.def_func
import pjl_value
import pjl_output
import pjl_printer
import Lpy.vendors.dummy_pjl

def get_dummy_class(pjlClass_name,dict_keys):
    pjl_dict  = {}
    for line in dict_keys:
        if line.startswith('Vendor_'):
            pjl_dict[line] = compile(pjlClass_name + '.' + line,pjlClass_name,"eval")
    return pjl_dict

class PJL_Vendor(Lpy.def_func.FuncSpace,pjl_value.PJL_Value,pjl_output.PJLout):
    dummy_dict = get_dummy_class("Lpy.vendors.dummy_pjl",Lpy.vendors.dummy_pjl.__dict__.keys())

    def __init__(self, maker = None,printertype = None):
        Lpy.def_func.FuncSpace.__init__(self)
        pjl_output.PJLout.__init__(self)

        self.printertype = None
        self.model = None
        ## PJL end reset
        self.pjl_Reset = self.OFF

    ## initialize 
    def init_support(self):
        self.printertype = self.get_func(self.P_type).get_value()
        self.model = self.get_func(self.P_model).get_value()
        for key in self.clist:
            if key in pjl_value.base_PJL_value:
                continue
            #print key
            self.get_func(key).check_model(self.printertype,self.model)

    def change_models(self,printertype,model):
        if printertype != self.printertype:
            self.get_func(self.P_type).set_value(printertype)
            self.get_func(self.P_model).check_model(printertype,None)
            self.printertype = self.get_func(self.P_type).get_value()

        if model != self.model:
            self.get_func(self.P_model).check_model(self.printertype,model)

        self.init_support()

    ## page_set.py :: Set tmp value ##
    def get_tmp_all(self): # support,value ==> tmp
        for key in self.clist:
            self.get_func(key).set_tmp_data()
    def set_tmp_all(self): # tmp ==> value
        for key in self.clist:
            self.get_func(key).set_tmp_value()

    def init_vendor(self,maker,printertype,model):
        if not self.d_classes:
            print "pjl_vendor.py init_vendor(%s.py)" % maker
            return None

        #print "init_vendor" ,maker,printertype,model

        locals_dict = {} # dummy_dict for Psyco

        setattr(self.dlist,self.P_printer,pjl_printer.PrinterInfo())
        setattr(self.dlist,self.P_maker  ,pjl_printer.PrinterMaker(maker))

        setattr(self.dlist,self.P_type ,
            eval(self.d_classes[self.base_dict[self.P_type]],globals(),locals_dict)(printertype,model))
        self.printertype = self.get_func(self.P_type).get_value()

        setattr(self.dlist,self.P_model,
            eval(self.d_classes[self.base_dict[self.P_model]],globals(),locals_dict)(self.printertype,model))
        self.model = self.get_func(self.P_model).get_value()

        setattr(self.dlist,self.P_lang,
            eval(self.d_classes[self.base_dict[self.P_lang]],globals(),locals_dict)(self.printertype,self.model))

        setattr(self.dlist,self.P_GS  ,
            eval(self.d_classes[self.base_dict[self.P_GS]],globals(),locals_dict)(self.printertype,self.model))

        d_classes_keys  = self.d_classes.keys()
        dummy_dict_keys = self.dummy_dict.keys()

        keys = self.pjl_dict.keys()
        keys.sort()
        for key in keys:
            if self.pjl_dict[key] in d_classes_keys:
                setattr(self.dlist,key,eval(self.d_classes[self.pjl_dict[key]],globals(),locals_dict)())

            elif self.pjl_dict[key] in dummy_dict_keys:
                #print "dummy",key
                setattr(self.dlist,key,eval(self.dummy_dict[self.pjl_dict[key]],globals(),locals_dict)())
            else:
                print "pjl_dict (%s,%s) is not a class." % (self.pjl_files, self.pjl_dict[key])
                # check program
                continue
            if getattr(self.dlist,key) is None:
                print "pjl_dict (%s,%s) has error." % (self.pjl_files, self.pjl_dict[key])

        self.set_clist()

