#   charset.py
#   ISO/character-sets ==> python dic
#
#   toolset.py  -m charset ISO/character-sets
#
#   2003.12.23
#   2004.8.1 modified from RFC3808
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
#
##############################################
charset = { # number : name,alias
    "1":     ('other',),
    "2":     ('unknown',),
    "3":     ('ANSI_X3.4-1968', ['iso-ir-6', 'ANSI_X3.4-1986', 'ISO_646.irv:1991', 'ASCII', 'ISO646-US', 'US-ASCII', 'us', 'IBM367', 'cp367', 'csASCII']),
    "4":     ('ISO_8859-1:1987', ['iso-ir-100', 'ISO_8859-1', 'ISO-8859-1', 'latin1', 'l1', 'IBM819', 'CP819', 'csISOLatin1']),
    "5":     ('ISO_8859-2:1987', ['iso-ir-101', 'ISO_8859-2', 'ISO-8859-2', 'latin2', 'l2', 'csISOLatin2']),
    "6":     ('ISO_8859-3:1988', ['iso-ir-109', 'ISO_8859-3', 'ISO-8859-3', 'latin3', 'l3', 'csISOLatin3']),
    "7":     ('ISO_8859-4:1988', ['iso-ir-110', 'ISO_8859-4', 'ISO-8859-4', 'latin4', 'l4', 'csISOLatin4']),
    "8":     ('ISO_8859-5:1988', ['iso-ir-144', 'ISO_8859-5', 'ISO-8859-5', 'cyrillic', 'csISOLatinCyrillic']),
    "9":     ('ISO_8859-6:1987', ['iso-ir-127', 'ISO_8859-6', 'ISO-8859-6', 'ECMA-114', 'ASMO-708', 'arabic', 'csISOLatinArabic']),
    "10":    ('ISO_8859-7:1987', ['iso-ir-126', 'ISO_8859-7', 'ISO-8859-7', 'ELOT_928', 'ECMA-118', 'greek', 'greek8', 'csISOLatinGreek']),
    "11":    ('ISO_8859-8:1988', ['iso-ir-138', 'ISO_8859-8', 'ISO-8859-8', 'hebrew', 'csISOLatinHebrew']),
    "12":    ('ISO_8859-9:1989', ['iso-ir-148', 'ISO_8859-9', 'ISO-8859-9', 'latin5', 'l5', 'csISOLatin5']),
    "13":    ('ISO-8859-10', ['iso-ir-157', 'l6', 'ISO_8859-10:1992', 'csISOLatin6', 'latin6']),
    "14":    ('ISO_6937-2-add', ['iso-ir-142', 'csISOTextComm']),
    "15":    ('JIS_X0201', ['X0201', 'csHalfWidthKatakana']),
    "16":    ('JIS_Encoding', ['csJISEncoding']),
    "17":    ('Shift_JIS', ['MS_Kanji', 'csShiftJIS']),
    "18":    ('Extended_UNIX_Code_Packed_Format_for_Japanese', ['csEUCPkdFmtJapanese', 'EUC-JP']),
    "19":    ('Extended_UNIX_Code_Fixed_Width_for_Japanese', ['csEUCFixWidJapanese']),
    "20":    ('BS_4730', ['iso-ir-4', 'ISO646-GB', 'gb', 'uk', 'csISO4UnitedKingdom']),
    "21":    ('SEN_850200_C', ['iso-ir-11', 'ISO646-SE2', 'se2', 'csISO11SwedishForNames']),
    "22":    ('IT', ['iso-ir-15', 'ISO646-IT', 'csISO15Italian']),
    "23":    ('ES', ['iso-ir-17', 'ISO646-ES', 'csISO17Spanish']),
    "24":    ('DIN_66003', ['iso-ir-21', 'de', 'ISO646-DE', 'csISO21German']),
    "25":    ('NS_4551-1', ['iso-ir-60', 'ISO646-NO', 'no', 'csISO60DanishNorwegian', 'csISO60Norwegian1']),
    "26":    ('NF_Z_62-010', ['iso-ir-69', 'ISO646-FR', 'fr', 'csISO69French']),
    "27":    ('ISO-10646-UTF-1', ['csISO10646UTF1']),
    "28":    ('ISO_646.basic:1983', ['ref', 'csISO646basic1983']),
    "29":    ('INVARIANT', ['csINVARIANT']),
    "30":    ('ISO_646.irv:1983', ['iso-ir-2', 'irv', 'csISO2IntlRefVersion']),
    "31":    ('NATS-SEFI', ['iso-ir-8-1', 'csNATSSEFI']),
    "32":    ('NATS-SEFI-ADD', ['iso-ir-8-2', 'csNATSSEFIADD']),
    "33":    ('NATS-DANO', ['iso-ir-9-1', 'csNATSDANO']),
    "34":    ('NATS-DANO-ADD', ['iso-ir-9-2', 'csNATSDANOADD']),
    "35":    ('SEN_850200_B', ['iso-ir-10', 'FI', 'ISO646-FI', 'ISO646-SE', 'se', 'csISO10Swedish']),
    "36":    ('KS_C_5601-1987', ['iso-ir-149', 'KS_C_5601-1989', 'KSC_5601', 'korean', 'csKSC56011987']),
    "37":    ('ISO-2022-KR', ['csISO2022KR']),
    "38":    ('EUC-KR', ['csEUCKR']),
    "39":    ('ISO-2022-JP', ['csISO2022JP']),
    "40":    ('ISO-2022-JP-2', ['csISO2022JP2']),
    "41":    ('JIS_C6220-1969-jp', ['JIS_C6220-1969', 'iso-ir-13', 'katakana', 'x0201-7', 'csISO13JISC6220jp']),
    "42":    ('JIS_C6220-1969-ro', ['iso-ir-14', 'jp', 'ISO646-JP', 'csISO14JISC6220ro']),
    "43":    ('PT', ['iso-ir-16', 'ISO646-PT', 'csISO16Portuguese']),
    "44":    ('greek7-old', ['iso-ir-18', 'csISO18Greek7Old']),
    "45":    ('latin-greek', ['iso-ir-19', 'csISO19LatinGreek']),
    "46":    ('NF_Z_62-010_(1973)', ['iso-ir-25', 'ISO646-FR1', 'csISO25French']),
    "47":    ('Latin-greek-1', ['iso-ir-27', 'csISO27LatinGreek1']),
    "48":    ('ISO_5427', ['iso-ir-37', 'csISO5427Cyrillic']),
    "49":    ('JIS_C6226-1978', ['iso-ir-42', 'csISO42JISC62261978']),
    "50":    ('BS_viewdata', ['iso-ir-47', 'csISO47BSViewdata']),
    "51":    ('INIS', ['iso-ir-49', 'csISO49INIS']),
    "52":    ('INIS-8', ['iso-ir-50', 'csISO50INIS8']),
    "53":    ('INIS-cyrillic', ['iso-ir-51', 'csISO51INISCyrillic']),
    "54":    ('ISO_5427:1981', ['iso-ir-54', 'ISO5427Cyrillic1981']),
    "55":    ('ISO_5428:1980', ['iso-ir-55', 'csISO5428Greek']),
    "56":    ('GB_1988-80', ['iso-ir-57', 'cn', 'ISO646-CN', 'csISO57GB1988']),
    "57":    ('GB_2312-80', ['iso-ir-58', 'chinese', 'csISO58GB231280']),
    "58":    ('NS_4551-2', ['ISO646-NO2', 'iso-ir-61', 'no2', 'csISO61Norwegian2']),
    "59":    ('videotex-suppl', ['iso-ir-70', 'csISO70VideotexSupp1']),
    "60":    ('PT2', ['iso-ir-84', 'ISO646-PT2', 'csISO84Portuguese2']),
    "61":    ('ES2', ['iso-ir-85', 'ISO646-ES2', 'csISO85Spanish2']),
    "62":    ('MSZ_7795.3', ['iso-ir-86', 'ISO646-HU', 'hu', 'csISO86Hungarian']),
    "63":    ('JIS_C6226-1983', ['iso-ir-87', 'x0208', 'JIS_X0208-1983', 'csISO87JISX0208']),
    "64":    ('greek7', ['iso-ir-88', 'csISO88Greek7']),
    "65":    ('ASMO_449', ['ISO_9036', 'arabic7', 'iso-ir-89', 'csISO89ASMO449']),
    "66":    ('iso-ir-90', ['csISO90']),
    "67":    ('JIS_C6229-1984-a', ['iso-ir-91', 'jp-ocr-a', 'csISO91JISC62291984a']),
    "68":    ('JIS_C6229-1984-b', ['iso-ir-92', 'ISO646-JP-OCR-B', 'jp-ocr-b', 'csISO92JISC62991984b']),
    "69":    ('JIS_C6229-1984-b-add', ['iso-ir-93', 'jp-ocr-b-add', 'csISO93JIS62291984badd']),
    "70":    ('JIS_C6229-1984-hand', ['iso-ir-94', 'jp-ocr-hand', 'csISO94JIS62291984hand']),
    "71":    ('JIS_C6229-1984-hand-add', ['iso-ir-95', 'jp-ocr-hand-add', 'csISO95JIS62291984handadd']),
    "72":    ('JIS_C6229-1984-kana', ['iso-ir-96', 'csISO96JISC62291984kana']),
    "73":    ('ISO_2033-1983', ['iso-ir-98', 'e13b', 'csISO2033']),
    "74":    ('ANSI_X3.110-1983', ['iso-ir-99', 'CSA_T500-1983', 'NAPLPS', 'csISO99NAPLPS']),
    "75":    ('T.61-7bit', ['iso-ir-102', 'csISO102T617bit']),
    "76":    ('T.61-8bit', ['T.61', 'iso-ir-103', 'csISO103T618bit']),
    "77":    ('ECMA-cyrillic', ['iso-ir-111', 'csISO111ECMACyrillic']),
    "78":    ('CSA_Z243.4-1985-1', ['iso-ir-121', 'ISO646-CA', 'csa7-1', 'ca', 'csISO121Canadian1']),
    "79":    ('CSA_Z243.4-1985-2', ['iso-ir-122', 'ISO646-CA2', 'csa7-2', 'csISO122Canadian2']),
    "80":    ('CSA_Z243.4-1985-gr', ['iso-ir-123', 'csISO123CSAZ24341985gr']),
    "81":    ('ISO_8859-6-E', ['csISO88596E', 'ISO-8859-6-E']),
    "82":    ('ISO_8859-6-I', ['csISO88596I', 'ISO-8859-6-I']),
    "83":    ('T.101-G2', ['iso-ir-128', 'csISO128T101G2']),
    "84":    ('ISO_8859-8-E', ['csISO88598E', 'ISO-8859-8-E']),
    "85":    ('ISO_8859-8-I', ['csISO88598I', 'ISO-8859-8-I']),
    "86":    ('CSN_369103', ['iso-ir-139', 'csISO139CSN369103']),
    "87":    ('JUS_I.B1.002', ['iso-ir-141', 'ISO646-YU', 'js', 'yu', 'csISO141JUSIB1002']),
    "88":    ('IEC_P27-1', ['iso-ir-143', 'csISO143IECP271']),
    "89":    ('JUS_I.B1.003-serb', ['iso-ir-146', 'serbian', 'csISO146Serbian']),
    "90":    ('JUS_I.B1.003-mac', ['macedonian', 'iso-ir-147', 'csISO147Macedonian']),
    "91":    ('greek-ccitt', ['iso-ir-150', 'csISO150', 'csISO150GreekCCITT']),
    "92":    ('NC_NC00-10:81', ['cuba', 'iso-ir-151', 'ISO646-CU', 'csISO151Cuba']),
    "93":    ('ISO_6937-2-25', ['iso-ir-152', 'csISO6937Add']),
    "94":    ('GOST_19768-74', ['ST_SEV_358-88', 'iso-ir-153', 'csISO153GOST1976874']),
    "95":    ('ISO_8859-supp', ['iso-ir-154', 'latin1-2-5', 'csISO8859Supp']),
    "96":    ('ISO_10367-box', ['iso-ir-155', 'csISO10367Box']),
    "97":    ('latin-lap', ['lap', 'iso-ir-158', 'csISO158Lap']),
    "98":    ('JIS_X0212-1990', ['x0212', 'iso-ir-159', 'csISO159JISX02121990']),
    "99":    ('DS_2089', ['DS2089', 'ISO646-DK', 'dk', 'csISO646Danish']),
    "100":   ('us-dk', ['csUSDK']),
    "101":   ('dk-us', ['csDKUS']),
    "102":   ('KSC5636', ['ISO646-KR', 'csKSC5636']),
    "103":   ('UNICODE-1-1-UTF-7', ['csUnicode11UTF7']),
    "104":   ('ISO-2022-CN', ),
    "105":   ('ISO-2022-CN-EXT', ),
    "106":   ('UTF-8', ),
    "109":   ('ISO-8859-13', ),
    "110":   ('ISO-8859-14', ['iso-ir-199', 'ISO_8859-14:1998', 'ISO_8859-14', 'latin8', 'iso-celtic', 'l8']),
    "111":   ('ISO-8859-15', ['ISO_8859-15', 'Latin-9']),
    "112":   ('ISO-8859-16', ['iso-ir-226', 'ISO_8859-16:2001', 'ISO_8859-16', 'latin10', 'l10']),
    "113":   ('GBK', ['CP936', 'MS936', 'windows-936']),
    "114":   ('GB18030', ),
    "115":   ('OSDEBCDICDF0415', ),
    "116":   ('OSDEBCDICDF03IRV', ),
    "117":   ('OSDEBCDICDF041', ),

    "1000":  ('ISO-10646-UCS-2', ['csUnicode']),
    "1001":  ('ISO-10646-UCS-4', ['csUCS4']),
    "1002":  ('ISO-10646-UCS-Basic', ['csUnicodeASCII']),
    "1003":  ('ISO-10646-Unicode-Latin1', ['csUnicodeLatin1', 'ISO-10646']),
    "1005":  ('ISO-10646-J-1', ['csUnicodeIBM1261']),
    "1006":  ('ISO-Unicode-IBM-1268', ['csUnicodeIBM1268']),
    "1007":  ('ISO-Unicode-IBM-1276', ['csUnicodeIBM1276']),
    "1008":  ('ISO-Unicode-IBM-1264', ['csUnicodeIBM1264']),
    "1009":  ('ISO-Unicode-IBM-1265', ['csUnicodeIBM1265']),
    "1010":  ('UNICODE-1-1', ['csUnicode11']),
    "1011":  ('SCSU', ),
    "1012":  ('UTF-7', ),
    "1013":  ('UTF-16BE', ),
    "1014":  ('UTF-16LE', ),
    "1015":  ('UTF-16', ),
    "1016":  ('CESU-8', ['csCESU-8']),
    "1017":  ('UTF-32', ),
    "1018":  ('UTF-32BE', ),
    "1019":  ('UTF-32LE', ),
    "1020":  ('BOCU-1', ['csBOCU-1']),
    "2000":  ('ISO-8859-1-Windows-3.0-Latin-1', ['csWindows30Latin1']),
    "2001":  ('ISO-8859-1-Windows-3.1-Latin-1', ['csWindows31Latin1']),
    "2002":  ('ISO-8859-2-Windows-Latin-2', ['csWindows31Latin2']),
    "2003":  ('ISO-8859-9-Windows-Latin-5', ['csWindows31Latin5']),
    "2004":  ('hp-roman8', ['roman8', 'r8', 'csHPRoman8']),
    "2005":  ('Adobe-Standard-Encoding', ['csAdobeStandardEncoding']),
    "2006":  ('Ventura-US', ['csVenturaUS']),
    "2007":  ('Ventura-International', ['csVenturaInternational']),
    "2008":  ('DEC-MCS', ['dec', 'csDECMCS']),
    "2009":  ('IBM850', ['cp850', '850', 'csPC850Multilingual']),
    "2010":  ('IBM852', ['cp852', '852', 'csPCp852']),
    "2011":  ('IBM437', ['cp437', '437', 'csPC8CodePage437']),
    "2012":  ('PC8-Danish-Norwegian', ['csPC8DanishNorwegian']),
    "2013":  ('IBM862', ['cp862', '862', 'csPC862LatinHebrew']),
    "2014":  ('PC8-Turkish', ['csPC8Turkish']),
    "2015":  ('IBM-Symbols', ['csIBMSymbols']),
    "2016":  ('IBM-Thai', ['csIBMThai']),
    "2017":  ('HP-Legal', ['csHPLegal']),
    "2018":  ('HP-Pi-font', ['csHPPiFont']),
    "2019":  ('HP-Math8', ['csHPMath8']),
    "2020":  ('Adobe-Symbol-Encoding', ['csHPPSMath']),
    "2021":  ('HP-DeskTop', ['csHPDesktop']),
    "2022":  ('Ventura-Math', ['csVenturaMath']),
    "2023":  ('Microsoft-Publishing', ['csMicrosoftPublishing']),
    "2024":  ('Windows-31J', ['csWindows31J']),
    "2025":  ('GB2312', ['csGB2312']),
    "2026":  ('Big5', ['csBig5']),
    "2027":  ('macintosh', ['mac', 'csMacintosh']),
    "2028":  ('IBM037', ['cp037', 'ebcdic-cp-us', 'ebcdic-cp-ca', 'ebcdic-cp-wt', 'ebcdic-cp-nl', 'csIBM037']),
    "2029":  ('IBM038', ['EBCDIC-INT', 'cp038', 'csIBM038']),
    "2030":  ('IBM273', ['CP273', 'csIBM273']),
    "2031":  ('IBM274', ['EBCDIC-BE', 'CP274', 'csIBM274']),
    "2032":  ('IBM275', ['EBCDIC-BR', 'cp275', 'csIBM275']),
    "2033":  ('IBM277', ['EBCDIC-CP-DK', 'EBCDIC-CP-NO', 'csIBM277']),
    "2034":  ('IBM278', ['CP278', 'ebcdic-cp-fi', 'ebcdic-cp-se', 'csIBM278']),
    "2035":  ('IBM280', ['CP280', 'ebcdic-cp-it', 'csIBM280']),
    "2036":  ('IBM281', ['EBCDIC-JP-E', 'cp281', 'csIBM281']),
    "2037":  ('IBM284', ['CP284', 'ebcdic-cp-es', 'csIBM284']),
    "2038":  ('IBM285', ['CP285', 'ebcdic-cp-gb', 'csIBM285']),
    "2039":  ('IBM290', ['cp290', 'EBCDIC-JP-kana', 'csIBM290']),
    "2040":  ('IBM297', ['cp297', 'ebcdic-cp-fr', 'csIBM297']),
    "2041":  ('IBM420', ['cp420', 'ebcdic-cp-ar1', 'csIBM420']),
    "2042":  ('IBM423', ['cp423', 'ebcdic-cp-gr', 'csIBM423']),
    "2043":  ('IBM424', ['cp424', 'ebcdic-cp-he', 'csIBM424']),
    "2044":  ('IBM500', ['CP500', 'ebcdic-cp-be', 'ebcdic-cp-ch', 'csIBM500']),
    "2045":  ('IBM851', ['cp851', '851', 'csIBM851']),
    "2046":  ('IBM855', ['cp855', '855', 'csIBM855']),
    "2047":  ('IBM857', ['cp857', '857', 'csIBM857']),
    "2048":  ('IBM860', ['cp860', '860', 'csIBM860']),
    "2049":  ('IBM861', ['cp861', '861', 'cp-is', 'csIBM861']),
    "2050":  ('IBM863', ['cp863', '863', 'csIBM863']),
    "2051":  ('IBM864', ['cp864', 'csIBM864']),
    "2052":  ('IBM865', ['cp865', '865', 'csIBM865']),
    "2053":  ('IBM868', ['CP868', 'cp-ar', 'csIBM868']),
    "2054":  ('IBM869', ['cp869', '869', 'cp-gr', 'csIBM869']),
    "2055":  ('IBM870', ['CP870', 'ebcdic-cp-roece', 'ebcdic-cp-yu', 'csIBM870']),
    "2056":  ('IBM871', ['CP871', 'ebcdic-cp-is', 'csIBM871']),
    "2057":  ('IBM880', ['cp880', 'EBCDIC-Cyrillic', 'csIBM880']),
    "2058":  ('IBM891', ['cp891', 'csIBM891']),
    "2059":  ('IBM903', ['cp903', 'csIBM903']),
    "2060":  ('IBM904', ['cp904', '904', 'csIBBM904']),
    "2061":  ('IBM905', ['CP905', 'ebcdic-cp-tr', 'csIBM905']),
    "2062":  ('IBM918', ['CP918', 'ebcdic-cp-ar2', 'csIBM918']),
    "2063":  ('IBM1026', ['CP1026', 'csIBM1026']),
    "2064":  ('EBCDIC-AT-DE', ['csIBMEBCDICATDE']),
    "2065":  ('EBCDIC-AT-DE-A', ['csEBCDICATDEA']),
    "2066":  ('EBCDIC-CA-FR', ['csEBCDICCAFR']),
    "2067":  ('EBCDIC-DK-NO', ['csEBCDICDKNO']),
    "2068":  ('EBCDIC-DK-NO-A', ['csEBCDICDKNOA']),
    "2069":  ('EBCDIC-FI-SE', ['csEBCDICFISE']),
    "2070":  ('EBCDIC-FI-SE-A', ['csEBCDICFISEA']),
    "2071":  ('EBCDIC-FR', ['csEBCDICFR']),
    "2072":  ('EBCDIC-IT', ['csEBCDICIT']),
    "2073":  ('EBCDIC-PT', ['csEBCDICPT']),
    "2074":  ('EBCDIC-ES', ['csEBCDICES']),
    "2075":  ('EBCDIC-ES-A', ['csEBCDICESA']),
    "2076":  ('EBCDIC-ES-S', ['csEBCDICESS']),
    "2077":  ('EBCDIC-UK', ['csEBCDICUK']),
    "2078":  ('EBCDIC-US', ['csEBCDICUS']),
    "2079":  ('UNKNOWN-8BIT', ['csUnknown8BiT']),
    "2080":  ('MNEMONIC', ['csMnemonic']),
    "2081":  ('MNEM', ['csMnem']),
    "2082":  ('VISCII', ['csVISCII']),
    "2083":  ('VIQR', ['csVIQR']),
    "2084":  ('KOI8-R', ['csKOI8R']),
    "2085":  ('HZ-GB-2312', ),
    "2086":  ('IBM866', ['cp866', '866', 'csIBM866']),
    "2087":  ('IBM775', ['cp775', 'csPC775Baltic']),
    "2088":  ('KOI8-U', ),
    "2089":  ('IBM00858', ['CCSID00858', 'CP00858', 'PC-Multilingual-850+euro']),
    "2090":  ('IBM00924', ['CCSID00924', 'CP00924', 'ebcdic-Latin9--euro']),
    "2091":  ('IBM01140', ['CCSID01140', 'CP01140', 'ebcdic-us-37+euro']),
    "2092":  ('IBM01141', ['CCSID01141', 'CP01141', 'ebcdic-de-273+euro']),
    "2093":  ('IBM01142', ['CCSID01142', 'CP01142', 'ebcdic-dk-277+euro', 'ebcdic-no-277+euro']),
    "2094":  ('IBM01143', ['CCSID01143', 'CP01143', 'ebcdic-fi-278+euro', 'ebcdic-se-278+euro']),
    "2095":  ('IBM01144', ['CCSID01144', 'CP01144', 'ebcdic-it-280+euro']),
    "2096":  ('IBM01145', ['CCSID01145', 'CP01145', 'ebcdic-es-284+euro']),
    "2097":  ('IBM01146', ['CCSID01146', 'CP01146', 'ebcdic-gb-285+euro']),
    "2098":  ('IBM01147', ['CCSID01147', 'CP01147', 'ebcdic-fr-297+euro']),
    "2099":  ('IBM01148', ['CCSID01148', 'CP01148', 'ebcdic-international-500+euro']),
    "2100":  ('IBM01149', ['CCSID01149', 'CP01149', 'ebcdic-is-871+euro']),
    "2101":  ('Big5-HKSCS', ),
    "2102":  ('IBM1047', ['IBM-1047']),
    "2103":  ('PTCP154', ['csPTCP154', 'PT154', 'CP154', 'Cyrillic-Asian']),
    "2104":  ('Amiga1251', ),
    "2105":  ('KOI7switched', ),

    "2250":  ('windows-1250', ),
    "2251":  ('windows-1251', ),
    "2252":  ('windows-1252', ),
    "2253":  ('windows-1253', ),
    "2254":  ('windows-1254', ),
    "2255":  ('windows-1255', ),
    "2256":  ('windows-1256', ),
    "2257":  ('windows-1257', ),
    "2258":  ('windows-1258', ),
    "2259":  ('TIS-620', ),
    }

def get_charset(key):
    if charset.has_key(key):
        return charset[key][0]
 
    return "charset Error (%s)" % key
